/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.xdb.ParallelConnectionHolder;
import kd.bos.xdb.mergeengine.ExecutionContext;

public class ErrorClose {
    private final ParallelConnectionHolder connectionHolder;
    private final Object lock = new Object();
    private Map<String, LinkedList<Connection>> conListMap = new ConcurrentHashMap<String, LinkedList<Connection>>();
    private Set<Statement> stmtMap = new HashSet<Statement>();

    public ErrorClose(ExecutionContext executionContext) {
        this.connectionHolder = executionContext.getConnectionHolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String curRoute, Connection con) {
        Object object = this.lock;
        synchronized (object) {
            LinkedList conList = this.conListMap.computeIfAbsent(curRoute, key -> new LinkedList());
            conList.add(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Statement stmt) {
        Object object = this.lock;
        synchronized (object) {
            this.stmtMap.add(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean rollback) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            try {
                for (Statement statement : this.stmtMap) {
                    if (statement.isClosed()) continue;
                    statement.close();
                }
                this.stmtMap.clear();
            }
            catch (Throwable throwable) {
                for (Map.Entry<String, LinkedList<Connection>> entry : this.conListMap.entrySet()) {
                    String curRoute = entry.getKey();
                    LinkedList<Connection> conList = entry.getValue();
                    for (Connection con : entry.getValue()) {
                        this.connectionHolder.closeConnection(curRoute, con, rollback);
                    }
                    conList.clear();
                }
                this.conListMap.clear();
                throw throwable;
            }
            for (Map.Entry entry : this.conListMap.entrySet()) {
                String curRoute = (String)entry.getKey();
                LinkedList conList = (LinkedList)entry.getValue();
                for (Connection con : (LinkedList)entry.getValue()) {
                    this.connectionHolder.closeConnection(curRoute, con, rollback);
                }
                conList.clear();
            }
            this.conListMap.clear();
        }
    }

    public void clear() {
        this.stmtMap.clear();
        for (Map.Entry<String, LinkedList<Connection>> entry : this.conListMap.entrySet()) {
            LinkedList<Connection> conList = entry.getValue();
            conList.clear();
        }
        this.conListMap.clear();
    }
}

