/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine;

import kd.bos.xdb.ParallelConnectionHolder;
import kd.bos.xdb.ParallelExecuteContext;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public class ExecutionContext {
    private final ParallelConnectionHolder connectionHolder = ConnectionProvider.get().getConnectionHolder();
    private final MetricsCollector metrics = MetricsCollector.getCurrent();
    private ParallelExecuteContext parallelExecuteContext = ExtContext.getParallelExecuteContext();
    private final String dbRoute = ExtContext.get().getDBRoute();
    private ShardingResult shardingResult;
    private SQLInfo[] sqlInfos;
    private SelectFeature selectFeature;
    private String originalSQL;
    private boolean forManager;
    private boolean writtenInTX;
    private int queryTimeoutSeconds;
    private String forManagerRoute;

    public ExecutionContext(ShardingResult shardingResult, String originalSQL, boolean forManager, String forManagerRoute, boolean writtenInTX, int queryTimeoutSeconds) {
        this.shardingResult = shardingResult;
        this.sqlInfos = shardingResult.getSQLInfos();
        this.selectFeature = shardingResult.getSelectFeature();
        this.originalSQL = originalSQL;
        this.forManager = forManager;
        this.writtenInTX = writtenInTX;
        this.queryTimeoutSeconds = queryTimeoutSeconds;
        this.forManagerRoute = forManagerRoute;
    }

    public ParallelConnectionHolder getConnectionHolder() {
        return this.connectionHolder;
    }

    public MetricsCollector getMetrics() {
        return this.metrics;
    }

    public ParallelExecuteContext getParallelExecuteContext() {
        return this.parallelExecuteContext;
    }

    public String getDbRoute() {
        return this.dbRoute;
    }

    public ShardingResult getShardingResult() {
        return this.shardingResult;
    }

    public SQLInfo[] getSqlInfos() {
        return this.sqlInfos;
    }

    public SelectFeature getSelectFeature() {
        return this.selectFeature;
    }

    public String getOriginalSQL() {
        return this.originalSQL;
    }

    public boolean isForManager() {
        return this.forManager;
    }

    public String getForManagerRoute() {
        return this.forManagerRoute;
    }

    public boolean isWrittenInTX() {
        return this.writtenInTX;
    }

    public int getQueryTimeoutSeconds() {
        return this.queryTimeoutSeconds;
    }
}

