/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.groupby.segmerge;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.mergeengine.groupby.aggregation.AggregationItem;
import kd.bos.xdb.mergeengine.groupby.aggregation.AggregationTypeEnum;
import kd.bos.xdb.mergeengine.groupby.aggregation.calculate.AggregationCal;
import kd.bos.xdb.mergeengine.groupby.aggregation.calculate.AggregationCalFactory;
import kd.bos.xdb.mergeengine.groupby.segmerge.GroupByDataSet;
import kd.bos.xdb.mergeengine.orderby.segmerge.DataSetsOrderBy;

public class DataSetsGroupBy
extends DataSetsOrderBy {
    private Object[] localCurrentRow;
    private List<?> currentGroupByValues;
    private List<AggregationItem> aggregationItems;
    private Map<AggregationItem, AggregationCal> aggregationCalMap;

    public DataSetsGroupBy(DataSet[] dataSets, SelectFeature sf) {
        super(dataSets, sf.getOrderByInfo());
        this.localCurrentRow = new Object[sf.getSelectItems().size()];
        this.currentGroupByValues = this.dataSetQueue.isEmpty() ? Collections.emptyList() : new GroupByDataSet(this.currentRow, this.orderByInfo).getGroupValues();
        this.collectAggregationItems(sf);
        this.aggregationCalMap = Maps.toMap(this.aggregationItems, iter -> AggregationCalFactory.create(iter.getType()));
    }

    private void collectAggregationItems(SelectFeature sf) {
        List<SQLSelectItem> selectItems = sf.getSelectItems();
        this.aggregationItems = new ArrayList<AggregationItem>(selectItems.size());
        for (int i = 0; i < selectItems.size(); ++i) {
            SQLExpr expr = selectItems.get(i).getExpr();
            if (!(expr instanceof SQLAggregateExpr)) continue;
            String methodName = ((SQLAggregateExpr)expr).getMethodName();
            AggregationTypeEnum typeEnum = AggregationTypeEnum.from(methodName);
            if (typeEnum == null) {
                throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"AggregateFunctionFactory_0", (String)"\u4e0d\u652f\u6301\u805a\u5408\u51fd\u6570:{0}", (Object[])new Object[]{methodName}));
            }
            this.aggregationItems.add(new AggregationItem(typeEnum, i + 1));
        }
    }

    @Override
    public boolean hasNext() throws SQLException {
        if (this.dataSetQueue.isEmpty()) {
            return false;
        }
        if (this.isFirstNext) {
            super.hasNext();
        }
        if (this.aggregateGroupValue()) {
            this.currentGroupByValues = new GroupByDataSet(this.currentRow, this.orderByInfo).getGroupValues();
        }
        return true;
    }

    @Override
    public Object[] next() throws SQLException {
        Object[] ret = new Object[this.localCurrentRow.length];
        System.arraycopy(this.localCurrentRow, 0, ret, 0, this.localCurrentRow.length);
        return ret;
    }

    private boolean aggregateGroupValue() throws SQLException {
        boolean result = false;
        boolean cachedRow = false;
        while (this.currentGroupByValues.equals(new GroupByDataSet(this.currentRow, this.orderByInfo).getGroupValues())) {
            this.aggregate(this.aggregationCalMap);
            if (!cachedRow) {
                this.cacheCurrentRow();
                cachedRow = true;
            }
            if (result = super.hasNext()) continue;
        }
        this.setAggregationValueToCurrentRow(this.aggregationCalMap);
        return result;
    }

    private void aggregate(Map<AggregationItem, AggregationCal> aggregationCalMap) throws SQLException {
        for (Map.Entry<AggregationItem, AggregationCal> entry : aggregationCalMap.entrySet()) {
            entry.getValue().calculate(this.getAggregationValue(entry.getKey()));
        }
    }

    private Comparable<?> getAggregationValue(AggregationItem aggregationItem) throws SQLException {
        Object result = this.currentRow.get(aggregationItem.getIndex() - 1);
        return (Comparable)result;
    }

    private void cacheCurrentRow() throws SQLException {
        for (int i = 0; i < this.currentRow.size(); ++i) {
            this.localCurrentRow[i] = this.currentRow.get(i);
        }
    }

    private void setAggregationValueToCurrentRow(Map<AggregationItem, AggregationCal> aggregationCalMap) {
        for (Map.Entry<AggregationItem, AggregationCal> entry : aggregationCalMap.entrySet()) {
            this.localCurrentRow[entry.getKey().getIndex() - 1] = entry.getValue().getResult();
            entry.getValue().reset();
        }
    }
}

