/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.groupby.segmerge;

import java.sql.SQLException;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.merge.resultset.ObjectConverter;
import kd.bos.xdb.mergeengine.groupby.segmerge.GroupbyAndOrderbySameMergeSet;
import kd.bos.xdb.mergeengine.orderby.segmerge.SegMergeDataSetBuilder;
import kd.bos.xdb.mergeengine.resultset.ExecutionLazyResultSet;

public class GroupbyAndOrderbyDiffMergeSet
extends GroupbyAndOrderbySameMergeSet {
    private DataSet dataSet;
    private Row curRow;

    public GroupbyAndOrderbyDiffMergeSet(ExecutionLazyResultSet executionLazyResultSet, SelectFeature sf) throws SQLException {
        super(executionLazyResultSet, sf);
        this.init();
    }

    private void init() {
        this.dataSet = new SegMergeDataSetBuilder(this.setsOrderBy, this.rowMeta, this.sf).build().orderBy(this.getOrderByFields(this.sf.getOriginalOrderByInfo()));
    }

    private String[] getOrderByFields(OrderByInfo obi) {
        List<OrderByInfo.OrderByItem> items = obi.getOrderByItems();
        String[] orderByFields = new String[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            orderByFields[i] = (String)this.dataSetColAliasMap.get(items.get(i).getIndex()) + (items.get(i).isAsc() ? " asc" : " desc");
        }
        return orderByFields;
    }

    @Override
    public boolean next() throws SQLException {
        boolean hasNest = this.dataSet.hasNext();
        if (hasNest) {
            this.curRow = this.dataSet.next();
        }
        return hasNest;
    }

    @Override
    public void close() throws SQLException {
        this.dataSet.close();
    }

    @Override
    public <T> T get(int columnIndex, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.curRow.get(columnIndex), type);
    }

    @Override
    public <T> T get(String columnName, Class<T> type) throws SQLException {
        int columnIndex = (Integer)this.colMetaNameIndexMap.get(columnName.toLowerCase());
        return this.get(columnIndex - 1, type);
    }
}

