/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.groupby.segmerge;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.mergeengine.groupby.aggregation.AggregationItem;
import kd.bos.xdb.mergeengine.groupby.aggregation.AggregationTypeEnum;
import kd.bos.xdb.mergeengine.groupby.aggregation.calculate.AggregationCal;
import kd.bos.xdb.mergeengine.groupby.aggregation.calculate.AggregationCalFactory;
import kd.bos.xdb.mergeengine.groupby.segmerge.GroupByResultSet;
import kd.bos.xdb.mergeengine.orderby.segmerge.ResultSetsOrderBy;

public class ResultSetsGroupBy
extends ResultSetsOrderBy {
    private Object[] currentRow;
    private List<?> currentGroupByValues;
    private List<AggregationItem> aggregationItems;
    private Map<AggregationItem, AggregationCal> aggregationCalMap;

    public ResultSetsGroupBy(ResultSet[] resultSets, SelectFeature sf) throws SQLException {
        super(resultSets, sf.getOrderByInfo());
        this.currentRow = new Object[sf.getSelectItems().size()];
        this.currentGroupByValues = this.resultSetQueue.isEmpty() ? Collections.emptyList() : new GroupByResultSet(this.currentResultSet, this.orderByInfo).getGroupValues();
        this.collectAggregationItems(sf);
        this.aggregationCalMap = Maps.toMap(this.aggregationItems, iter -> AggregationCalFactory.create(iter.getType()));
    }

    private void collectAggregationItems(SelectFeature sf) {
        List<SQLSelectItem> selectItems = sf.getSelectItems();
        this.aggregationItems = new ArrayList<AggregationItem>(selectItems.size());
        for (int i = 0; i < selectItems.size(); ++i) {
            SQLExpr expr = selectItems.get(i).getExpr();
            if (!(expr instanceof SQLAggregateExpr)) continue;
            String methodName = ((SQLAggregateExpr)expr).getMethodName();
            AggregationTypeEnum typeEnum = AggregationTypeEnum.from(methodName);
            if (typeEnum == null) {
                throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"AggregateFunctionFactory_0", (String)"\u4e0d\u652f\u6301\u805a\u5408\u51fd\u6570:{0}", (Object[])new Object[]{methodName}));
            }
            this.aggregationItems.add(new AggregationItem(typeEnum, i + 1));
        }
    }

    @Override
    public boolean hasNext() throws SQLException {
        if (this.resultSetQueue.isEmpty()) {
            return false;
        }
        if (this.isFirstNext) {
            super.hasNext();
        }
        if (this.aggregateGroupValue()) {
            this.currentGroupByValues = new GroupByResultSet(this.currentResultSet, this.orderByInfo).getGroupValues();
        }
        return true;
    }

    @Override
    public Object[] next() throws SQLException {
        Object[] ret = new Object[this.currentRow.length];
        System.arraycopy(this.currentRow, 0, ret, 0, this.currentRow.length);
        return ret;
    }

    private boolean aggregateGroupValue() throws SQLException {
        boolean result = false;
        boolean cachedRow = false;
        while (this.currentGroupByValues.equals(new GroupByResultSet(this.currentResultSet, this.orderByInfo).getGroupValues())) {
            this.aggregate(this.aggregationCalMap);
            if (!cachedRow) {
                this.cacheCurrentRow();
                cachedRow = true;
            }
            if (result = super.hasNext()) continue;
        }
        this.setAggregationValueToCurrentRow(this.aggregationCalMap);
        return result;
    }

    private void aggregate(Map<AggregationItem, AggregationCal> aggregationCalMap) throws SQLException {
        for (Map.Entry<AggregationItem, AggregationCal> entry : aggregationCalMap.entrySet()) {
            entry.getValue().calculate(this.getAggregationValue(entry.getKey()));
        }
    }

    private Comparable<?> getAggregationValue(AggregationItem aggregationItem) throws SQLException {
        Object result = this.currentResultSet.getObject(aggregationItem.getIndex());
        return (Comparable)result;
    }

    private void cacheCurrentRow() throws SQLException {
        for (int i = 0; i < this.currentResultSet.getMetaData().getColumnCount(); ++i) {
            this.currentRow[i] = this.currentResultSet.getObject(i + 1);
        }
    }

    private void setAggregationValueToCurrentRow(Map<AggregationItem, AggregationCal> aggregationCalMap) {
        for (Map.Entry<AggregationItem, AggregationCal> entry : aggregationCalMap.entrySet()) {
            this.currentRow[entry.getKey().getIndex() - 1] = entry.getValue().getResult();
            entry.getValue().reset();
        }
    }
}

