/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.iterator;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.merge.CacheResultSetMetaData;
import kd.bos.xdb.merge.resultset.ObjectConverter;
import kd.bos.xdb.mergeengine.resultset.AbstractMergeSet;
import kd.bos.xdb.mergeengine.resultset.ExecutionLazyResultSet;

public class IteratorMergeSet
extends AbstractMergeSet {
    private boolean prepare = false;

    public IteratorMergeSet(ExecutionLazyResultSet executionLazyResultSet) throws SQLException {
        this.executionLazyResultSet = executionLazyResultSet;
        this.init();
    }

    private void init() throws SQLException {
        DBType dbType = ExtContext.get().getDBType();
        boolean bl = this.oracleSeries = dbType == DBType.oracle || dbType == DBType.dm || dbType == DBType.yasdb || dbType == DBType.oceanbase_oracle || dbType == DBType.hana;
        if (this.oracleSeries) {
            CacheResultSetMetaData cacheResultSetMetaData = new CacheResultSetMetaData(this.executionLazyResultSet.getResultSet().getMetaData());
            this.md = cacheResultSetMetaData;
        }
    }

    @Override
    public boolean next() throws SQLException {
        return this.executionLazyResultSet.next();
    }

    @Override
    public void close() throws SQLException {
        this.executionLazyResultSet.close();
    }

    @Override
    public <T> T get(int columnIndex, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.executionLazyResultSet.getResultSet().getObject(columnIndex + 1), type);
    }

    @Override
    public <T> T get(String columnName, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.executionLazyResultSet.getResultSet().getObject(columnName), type);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (!this.prepare) {
            this.init();
        }
        if (this.oracleSeries) {
            return this.md;
        }
        return this.executionLazyResultSet.getResultSet().getMetaData();
    }
}

