/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.orderby.segmerge;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.store.Store;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.resultset.ObjectConverter;
import kd.bos.xdb.mergeengine.orderby.segmerge.EmptyStore;
import kd.bos.xdb.mergeengine.orderby.segmerge.SegMergeStoreBuilder;
import kd.bos.xdb.mergeengine.orderby.segmerge.SegMergeThreadPools;
import kd.bos.xdb.mergeengine.orderby.segmerge.SetsOrderBy;
import kd.bos.xdb.mergeengine.resultset.AbstractMergeSet;

public abstract class AbstractSegMergeSet
extends AbstractMergeSet
implements XDBLogable {
    protected final int streamSize;
    protected final int perSegSize;
    protected final int perStoreSize;
    protected RowMeta rowMeta;
    protected static final String ALIAS_PREFIX = "segmerge_";
    protected Map<Integer, String> dataSetColAliasMap = new HashMap<Integer, String>(16);
    protected static final EmptyStore EOF_STORE = new EmptyStore();
    protected final BlockingQueue<Store> storeQueue = new LinkedBlockingQueue<Store>();
    protected SetsOrderBy setsOrderBy;

    public AbstractSegMergeSet() {
        this.streamSize = XDBConfig.getMergeStreamParallelSize();
        this.perSegSize = XDBConfig.getMergePerSegSize();
        this.perStoreSize = XDBConfig.getMergePerStoreSize();
    }

    protected Store[] merge(Store[] stores) throws SQLException {
        if (stores.length <= this.perStoreSize) {
            return stores;
        }
        List<Store[]> splitList = this.split(stores, this.perStoreSize);
        return this.merge(XDBConfig.isMergeSegParallelExecute() ? this.asyncMerge(splitList) : this.syncMerge(splitList));
    }

    private Store[] syncMerge(List<Store[]> storeArrayList) {
        Store[] segMerges = new Store[storeArrayList.size()];
        int i = 0;
        for (Store[] storeArray : storeArrayList) {
            segMerges[i++] = new SegMergeStoreBuilder(this.storesOrderBy(storeArray), this.rowMeta, this.sf).build();
        }
        return segMerges;
    }

    private Store[] asyncMerge(List<Store[]> storeArrayList) throws SQLException {
        ArrayList<Future<Store>> listFS = new ArrayList<Future<Store>>(storeArrayList.size());
        for (Store[] storeArray : storeArrayList) {
            listFS.add(SegMergeThreadPools.submit(() -> new SegMergeStoreBuilder(this.storesOrderBy(storeArray), this.rowMeta, this.sf).build()));
        }
        Store[] segMerges = new Store[storeArrayList.size()];
        int i = 0;
        for (Future future : listFS) {
            try {
                segMerges[i++] = (Store)future.get();
            }
            catch (Exception e) {
                throw ExceptionUtil.as(SQLException.class, e);
            }
        }
        return segMerges;
    }

    protected abstract SetsOrderBy storesOrderBy(Store[] var1);

    protected List<DataSet[]> split(DataSet[] dataSets, int segSize) {
        if (dataSets.length <= segSize) {
            return Collections.singletonList(dataSets);
        }
        int n = dataSets.length;
        ArrayList<DataSet[]> ret = new ArrayList<DataSet[]>(n / segSize + 1);
        ArrayList<DataSet> list = new ArrayList<DataSet>(segSize);
        for (int i = 0; i < n; ++i) {
            if (i % segSize == 0 && i != 0) {
                ret.add(list.toArray(new DataSet[segSize]));
                list.clear();
            }
            list.add(dataSets[i]);
        }
        if (!list.isEmpty()) {
            ret.add(list.toArray(new DataSet[list.size()]));
        }
        return ret;
    }

    protected List<Store[]> split(Store[] stores, int segSize) {
        if (stores.length <= segSize) {
            return Collections.singletonList(stores);
        }
        int n = stores.length;
        ArrayList<Store[]> ret = new ArrayList<Store[]>(n / segSize + 1);
        ArrayList<Store> list = new ArrayList<Store>(segSize);
        for (int i = 0; i < n; ++i) {
            if (i % segSize == 0 && i != 0) {
                ret.add(list.toArray(new Store[segSize]));
                list.clear();
            }
            list.add(stores[i]);
        }
        if (!list.isEmpty()) {
            ret.add(list.toArray(new Store[list.size()]));
        }
        return ret;
    }

    @Override
    public void close() throws SQLException {
        this.setsOrderBy.close();
    }

    @Override
    public <T> T get(int columnIndex, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.setsOrderBy.get(columnIndex), type);
    }

    @Override
    public <T> T get(String columnName, Class<T> type) throws SQLException {
        int columnIndex = (Integer)this.colMetaNameIndexMap.get(columnName.toLowerCase());
        return this.get(columnIndex - 1, type);
    }

    protected RowMeta getRowMeta() {
        try {
            ResultSetMetaData meta = this.executionLazyResultSet.getResultSet().getMetaData();
            Field[] fields = new Field[meta.getColumnCount()];
            for (int i = 0; i < fields.length; ++i) {
                int sqlType = meta.getColumnType(i + 1);
                String alais = ALIAS_PREFIX + i;
                this.dataSetColAliasMap.put(i + 1, ALIAS_PREFIX + i);
                fields[i] = new Field(alais, DataType.fromSqlType((int)sqlType), true);
            }
            return new RowMeta(fields);
        }
        catch (SQLException e) {
            throw new AlgoException((Throwable)e);
        }
    }
}

