/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.orderby.segmerge;

import java.sql.SQLException;
import java.util.PriorityQueue;
import java.util.Queue;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.mergeengine.orderby.comparable.DataSetComparable;
import kd.bos.xdb.mergeengine.orderby.segmerge.SetsOrderBy;

public class DataSetsOrderBy
implements SetsOrderBy {
    private DataSet[] dataSets;
    protected Row currentRow;
    protected OrderByInfo orderByInfo;
    protected Queue<DataSetComparable> dataSetQueue;
    protected boolean isFirstNext;

    public DataSetsOrderBy(DataSet[] dataSets, OrderByInfo orderByInfo) {
        this.dataSets = dataSets;
        this.orderByInfo = orderByInfo;
        this.init();
    }

    private void init() {
        this.dataSetQueue = new PriorityQueue<DataSetComparable>(this.dataSets.length);
        for (DataSet dataSet : this.dataSets) {
            DataSetComparable dataSetComparable = new DataSetComparable(dataSet, this.orderByInfo);
            if (!dataSetComparable.next()) continue;
            this.dataSetQueue.offer(dataSetComparable);
        }
        this.currentRow = this.dataSetQueue.isEmpty() ? null : this.dataSetQueue.peek().getCurRow();
        this.isFirstNext = true;
    }

    @Override
    public boolean hasNext() throws SQLException {
        if (this.dataSetQueue.isEmpty()) {
            return false;
        }
        if (this.isFirstNext) {
            this.isFirstNext = false;
            return true;
        }
        DataSetComparable firstDataSet = this.dataSetQueue.poll();
        if (firstDataSet.next()) {
            this.dataSetQueue.offer(firstDataSet);
        }
        if (this.dataSetQueue.isEmpty()) {
            return false;
        }
        this.currentRow = this.dataSetQueue.peek().getCurRow();
        return true;
    }

    @Override
    public Object[] next() throws SQLException {
        Object[] values = new Object[this.currentRow.size()];
        for (int i = 0; i < this.currentRow.size(); ++i) {
            values[i] = this.currentRow.get(i);
        }
        return values;
    }

    @Override
    public Object get(int index) throws SQLException {
        return this.currentRow.get(index);
    }

    @Override
    public void close() throws SQLException {
        for (DataSet dataSet : this.dataSets) {
            if (dataSet == null) continue;
            dataSet.close();
        }
    }
}

