/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.orderby.segmerge;

import java.sql.SQLException;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.RowMeta;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.mergeengine.orderby.segmerge.SetsOrderBy;

public class SegMergeDataSetBuilder {
    private RowMeta rowMeta;
    protected int length = Integer.MAX_VALUE;
    private SetsOrderBy setsOrderBy;
    private DataSet ds;

    public SegMergeDataSetBuilder(SetsOrderBy setsOrderBy, RowMeta rowMeta, SelectFeature sf) {
        this.setsOrderBy = setsOrderBy;
        this.rowMeta = rowMeta;
        if (sf != null && sf.hasLimit() && !sf.hasDistinct() && !sf.hasGroupBy()) {
            this.length = sf.getOffset() + sf.getLength();
        }
    }

    public DataSet build() {
        try {
            String algoKey = this.getClass().toString();
            Algo algo = Algo.create((String)algoKey);
            DataSetBuilder builder = algo.createDataSetBuilder(this.rowMeta);
            int i = 0;
            while (this.setsOrderBy.hasNext() && i++ < this.length) {
                builder.append(this.setsOrderBy.next());
            }
            DataSet dataSet = this.ds = builder.build();
            return dataSet;
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
        finally {
            try {
                this.setsOrderBy.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void close() {
        if (this.ds != null) {
            this.ds.close();
        }
    }
}

