/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.orderby.segmerge;

import java.sql.SQLException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.mergeengine.orderby.segmerge.SetsOrderBy;

public class SegMergeStoreBuilder {
    private RowMeta rowMeta;
    private int length = Integer.MAX_VALUE;
    private SetsOrderBy setsOrderBy;
    private Store store;

    public SegMergeStoreBuilder(SetsOrderBy setsOrderBy, RowMeta rowMeta, SelectFeature sf) {
        this.setsOrderBy = setsOrderBy;
        this.rowMeta = rowMeta;
        if (sf != null && sf.hasLimit() && !sf.hasDistinct() && !sf.hasGroupBy()) {
            this.length = sf.getOffset() + sf.getLength();
        }
    }

    public Store build() {
        try {
            int i = 0;
            this.store = StoreFactory.createStandaloneDataSetBackStore((RowMeta)this.rowMeta);
            while (this.setsOrderBy.hasNext() && i++ < this.length) {
                this.store.write((Row)RowFactory.createPersistedRow((RowMeta)this.rowMeta, (Object[])this.setsOrderBy.next(), (boolean)false));
            }
            Store store = this.store;
            return store;
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
        finally {
            try {
                this.setsOrderBy.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void close() {
        if (this.store != null) {
            this.store.close();
        }
    }
}

