/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.orderby.segmerge;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.thread.SetThreadName;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.ThreadLocals;

public class SegMergeThreadPools {
    private static int coreThreads = 3;
    private static int maxThreads = 200;
    private static final ThreadFactory tf;
    private static ExecutorService pools;

    public static <V> Future<V> submit(Callable<V> callable) {
        String traceId = TraceIdUtil.getCurrentTraceIdString();
        return pools.submit(() -> {
            try {
                SetThreadName.start();
                if (StringUtils.isNotEmpty((String)traceId)) {
                    TraceIdUtil.setCurrentTraceId((String)traceId);
                }
                Object v = callable.call();
                return v;
            }
            finally {
                SetThreadName.end();
                ThreadLocals.release();
            }
        });
    }

    static {
        ConfigurationUtil.observeInteger((String)"xdb.sort.threadpool.coresize", (int)3, v -> {
            coreThreads = v;
        });
        ConfigurationUtil.observeInteger((String)"xdb.sort.threadpool.maxsize", (int)200, v -> {
            maxThreads = v;
        });
        tf = new ThreadFactory(){
            private final ThreadGroup g = new ThreadGroup("XDB-SegMerge");

            @Override
            public Thread newThread(Runnable r) {
                return new SegMergeThread(this.g, r);
            }
        };
        pools = ThreadLifeCycleManager.wrapExecutorService((ExecutorService)new ThreadPoolExecutor(coreThreads, maxThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), tf));
    }

    public static class SegMergeThread
    extends Thread {
        private static AtomicInteger seq = new AtomicInteger();

        public SegMergeThread(ThreadGroup g, Runnable r) {
            super(g, r);
            this.setName("XDB-SegMerge-" + seq.incrementAndGet());
            this.setDaemon(true);
        }
    }
}

