/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.orderby.segmerge;

import java.sql.SQLException;
import java.util.PriorityQueue;
import java.util.Queue;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.store.Store;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.mergeengine.orderby.comparable.StoreComparable;
import kd.bos.xdb.mergeengine.orderby.segmerge.SetsOrderBy;

public class StoresOrderBy
implements SetsOrderBy {
    private Store[] stores;
    protected Row currentRow;
    protected OrderByInfo orderByInfo;
    protected Queue<StoreComparable> storesQueue;
    protected boolean isFirstNext;

    public StoresOrderBy(Store[] stores, OrderByInfo orderByInfo) {
        this.stores = stores;
        this.orderByInfo = orderByInfo;
        this.init();
    }

    private void init() {
        this.storesQueue = new PriorityQueue<StoreComparable>(this.stores.length);
        for (Store store : this.stores) {
            StoreComparable storeComparable = new StoreComparable(store, this.orderByInfo);
            if (!storeComparable.next()) continue;
            this.storesQueue.offer(storeComparable);
        }
        this.currentRow = this.storesQueue.isEmpty() ? null : this.storesQueue.peek().getCurRow();
        this.isFirstNext = true;
    }

    @Override
    public boolean hasNext() throws SQLException {
        if (this.storesQueue.isEmpty()) {
            return false;
        }
        if (this.isFirstNext) {
            this.isFirstNext = false;
            return true;
        }
        StoreComparable firstStore = this.storesQueue.poll();
        if (firstStore.next()) {
            this.storesQueue.offer(firstStore);
        }
        if (this.storesQueue.isEmpty()) {
            return false;
        }
        this.currentRow = this.storesQueue.peek().getCurRow();
        return true;
    }

    @Override
    public Object[] next() throws SQLException {
        Object[] values = new Object[this.currentRow.size()];
        for (int i = 0; i < this.currentRow.size(); ++i) {
            values[i] = this.currentRow.get(i);
        }
        return values;
    }

    @Override
    public Object get(int index) throws SQLException {
        return this.currentRow.get(index);
    }

    @Override
    public void close() throws SQLException {
        for (Store store : this.stores) {
            if (store == null) continue;
            store.close();
        }
    }
}

