/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.resultset;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.mergeengine.resultset.ExecutionLazyResultSet;

public abstract class AbstractMergeSet
implements MergeSet {
    protected SelectFeature sf;
    protected Map<String, Integer> colMetaNameIndexMap = new HashMap<String, Integer>(16);
    protected Map<Integer, String> colIndexNameMap = new HashMap<Integer, String>(16);
    protected Map<String, Integer> colExprNameIndexMap = new HashMap<String, Integer>(16);
    protected ExecutionLazyResultSet executionLazyResultSet;
    protected ResultSetMetaData md;
    protected boolean oracleSeries = false;

    protected void flushMetaNameIndex(ResultSet resultSet) throws SQLException {
        this.flushExprNameIndex();
        this.flushMetaNameIndex(resultSet.getMetaData());
    }

    protected void flushMetaNameIndex(ResultSetMetaData md) {
        try {
            int cols = md.getColumnCount();
            for (int i = 0; i < cols; ++i) {
                String name = md.getColumnName(i + 1).toLowerCase();
                Integer index = i + 1;
                this.colMetaNameIndexMap.put(name, index);
                this.colIndexNameMap.put(index, name);
            }
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    protected void flushExprNameIndex() {
        int cols = this.sf.getSelectItems().size();
        for (int i = 0; i < cols; ++i) {
            String aliasName = this.sf.getSelectItems().get(i).getExpr().toString();
            if (aliasName == null) continue;
            this.colExprNameIndexMap.putIfAbsent(aliasName.toLowerCase(), i + 1);
        }
    }
}

