/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.resultset;

import java.sql.SQLException;
import java.util.Iterator;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mergeengine.resultset.ExecutionLazyResultSet;

public class ExecutionLazyIterator
implements Iterator<Object[]> {
    private ExecutionLazyResultSet executionLazyResultSet;
    private final int count;

    public ExecutionLazyIterator(ExecutionLazyResultSet executionLazyResultSet) throws SQLException {
        this.executionLazyResultSet = executionLazyResultSet;
        this.count = executionLazyResultSet.getResultSet().getMetaData().getColumnCount();
    }

    @Override
    public boolean hasNext() {
        try {
            return this.executionLazyResultSet.next();
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public Object[] next() {
        try {
            Object[] values = new Object[this.count];
            for (int i = 0; i < this.count; ++i) {
                values[i] = this.executionLazyResultSet.getResultSet().getObject(i + 1);
            }
            return values;
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }
}

