/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.resultset;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.ksql.KSQLThreadCache;
import kd.bos.ksql.shell.timeout.context.ThreadRouteKeyContext;
import kd.bos.thread.ShardingStats;
import kd.bos.util.StringUtils;
import kd.bos.xdb.ParallelExecuteContext;
import kd.bos.xdb.ParallelExecutor;
import kd.bos.xdb.ParallelTag;
import kd.bos.xdb.ParameterSetter;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBLog;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.id.IDUtil;
import kd.bos.xdb.jdbc.connection.XDBConnection;
import kd.bos.xdb.jdbc.statement.XDBPrepareStatement;
import kd.bos.xdb.merge.ResultSetFactory;
import kd.bos.xdb.merge.resultset.fetched.FetchedResultSet;
import kd.bos.xdb.mergeengine.ErrorClose;
import kd.bos.xdb.mergeengine.ExecutionContext;
import kd.bos.xdb.mergeengine.QueryConnHolder;
import kd.bos.xdb.parameter.ParameterFillerFactory;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.util.Pair;
import kd.bos.xdb.xpm.metrics.collector.StatTimeStamp;

public class ExecutionLazyResultSet
implements XDBLogable {
    private final long parallelId;
    private ExecutionContext executionContext;
    private final ErrorClose errorClose;
    private boolean isStream = false;
    private int last = 0;
    private ResultSet[] resultSets;
    private int i;
    private ResultSet resultSet;
    private List<Future<ResultSet>> preLosdListFS;
    private boolean hasNextLoad;
    final int mergeStableParallelSize = XDBConfig.getMergeStableParallelSize();
    final int preLoadSize = this.mergeStableParallelSize > 3 ? this.mergeStableParallelSize / 2 + 1 : 2;
    private volatile boolean firstPrepare = false;

    public ExecutionLazyResultSet(ExecutionContext executionContext) {
        this.parallelId = IDUtil.id();
        this.executionContext = executionContext;
        this.errorClose = new ErrorClose(this.executionContext);
    }

    public void setStream(boolean stream) {
        this.isStream = stream;
    }

    public void close() throws SQLException {
        int j;
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
            for (j = this.i; j < this.resultSets.length; ++j) {
                if (this.resultSets[j] == null || this.resultSets[j].isClosed()) continue;
                this.resultSets[j].close();
                this.resultSets[j] = null;
            }
            this.resultSets = null;
        }
        if (this.getResultSetForFuture()) {
            for (j = 0; j < this.resultSets.length; ++j) {
                if (this.resultSets[j] == null || this.resultSets[j].isClosed()) continue;
                this.resultSets[j].close();
                this.resultSets[j] = null;
            }
            this.resultSets = null;
        }
    }

    public int getSqlsLength() {
        return this.executionContext.getSqlInfos().length;
    }

    public ResultSet getResultSet() throws SQLException {
        this.init();
        return this.resultSet;
    }

    public ResultSet[] getResultSetSet() throws SQLException {
        this.init();
        return this.resultSets;
    }

    public ResultSet[] getResultSetSet(int n) throws SQLException {
        ResultSet[] returnResultSets = new ResultSet[n];
        for (int k = 0; k < n; ++k) {
            returnResultSets[k] = this.getResultSet();
            if (this.nextResultSet()) continue;
            ResultSet[] tempResultSets = new ResultSet[k + 1];
            System.arraycopy(returnResultSets, 0, tempResultSets, 0, k + 1);
            returnResultSets = tempResultSets;
            break;
        }
        return returnResultSets;
    }

    private void init() throws SQLException {
        if (!this.firstPrepare) {
            this.loadResultSet();
        }
    }

    public boolean next() throws SQLException {
        this.init();
        if (this.resultSet.next()) {
            return true;
        }
        while (this.nextResultSet()) {
            if (!this.resultSet.next()) continue;
            return true;
        }
        return false;
    }

    private boolean nextResultSet() throws SQLException {
        if (this.i < this.resultSets.length) {
            this.resultSet = this.resultSets[this.i++];
            if (this.hasNextLoad && !this.isStream && this.i == this.preLoadSize) {
                Pair<Boolean, List<Future<ResultSet>>> pair = this.doLoadFutureResultSet();
                this.hasNextLoad = pair.getKey();
                this.preLosdListFS = pair.getValue();
            }
            return true;
        }
        return this.getResultSetForFuture();
    }

    public boolean loadResultSet() throws SQLException {
        Pair<Boolean, ResultSet[]> pair = this.doLoadResultSet();
        this.hasNextLoad = pair.getKey();
        this.resultSets = pair.getValue();
        if (this.resultSets != null) {
            this.resultSet = this.resultSets[0];
            this.i = 1;
            return true;
        }
        return false;
    }

    private boolean getResultSetForFuture() throws SQLException {
        if (this.preLosdListFS != null && !this.preLosdListFS.isEmpty()) {
            try {
                ArrayList<ResultSet> rsList = new ArrayList<ResultSet>(this.preLosdListFS.size());
                for (Future<ResultSet> f : this.preLosdListFS) {
                    rsList.add(f.get());
                }
                this.resultSets = rsList.toArray(new ResultSet[rsList.size()]);
                this.resultSet = this.resultSets[0];
                this.i = 1;
                this.preLosdListFS.clear();
                this.errorClose.clear();
                return true;
            }
            catch (Exception e) {
                this.errorClose.close(true);
                throw ExceptionUtil.as(SQLException.class, e);
            }
        }
        return false;
    }

    private Pair<Boolean, ResultSet[]> doLoadResultSet() throws SQLException {
        int leftover = this.executionContext.getSqlInfos().length - this.last;
        if (leftover > 0) {
            int loadRsCnt = this.isStream ? leftover : Math.min(leftover, this.mergeStableParallelSize);
            ArrayList<ResultSet> rsList = new ArrayList<ResultSet>(loadRsCnt);
            try {
                this.errorClose.clear();
                if (this.executionContext.isForManager() || loadRsCnt == 1) {
                    for (int i = 0; i < loadRsCnt; ++i) {
                        SQLInfo si = this.executionContext.getSqlInfos()[this.last++];
                        rsList.add(this.syncExecute(si));
                    }
                } else {
                    ArrayList<Future<ResultSet>> listFS = new ArrayList<Future<ResultSet>>(loadRsCnt);
                    AtomicInteger completedCount = new AtomicInteger(this.last);
                    Semaphore sp = new Semaphore(XDBConfig.get().getSingleParallelSize());
                    for (int i = 0; i < loadRsCnt; ++i) {
                        SQLInfo sQLInfo = this.executionContext.getSqlInfos()[this.last++];
                        ParallelTag tag = new ParallelTag(this.parallelId, this.last, this.executionContext.getSqlInfos().length, completedCount);
                        tag.setSqlInfo(sQLInfo);
                        listFS.add(this.asyncExecute(sQLInfo, tag, sp));
                    }
                    for (Future future : listFS) {
                        rsList.add((ResultSet)future.get());
                    }
                }
                if (!this.firstPrepare) {
                    this.firstPrepare = true;
                }
                return new Pair<Boolean, ResultSet[]>(leftover > loadRsCnt, rsList.toArray(new ResultSet[rsList.size()]));
            }
            catch (Exception e) {
                this.errorClose.close(true);
                throw ExceptionUtil.as(SQLException.class, e);
            }
        }
        return new Pair<Boolean, Object>(false, null);
    }

    private Pair<Boolean, List<Future<ResultSet>>> doLoadFutureResultSet() throws SQLException {
        int leftover = this.executionContext.getSqlInfos().length - this.last;
        if (leftover > 0) {
            int loadRsCnt = Math.min(leftover, this.mergeStableParallelSize);
            try {
                this.errorClose.clear();
                ArrayList<Future<ResultSet>> listFS = new ArrayList<Future<ResultSet>>(loadRsCnt);
                AtomicInteger completedCount = new AtomicInteger(this.last);
                Semaphore sp = new Semaphore(XDBConfig.get().getSingleParallelSize());
                for (int i = 0; i < loadRsCnt; ++i) {
                    SQLInfo si = this.executionContext.getSqlInfos()[this.last++];
                    ParallelTag tag = new ParallelTag(this.parallelId, this.last, this.executionContext.getSqlInfos().length, completedCount);
                    tag.setSqlInfo(si);
                    listFS.add(this.asyncExecute(si, tag, sp));
                }
                return new Pair<Boolean, List<Future<ResultSet>>>(leftover > loadRsCnt, listFS);
            }
            catch (Exception e) {
                this.errorClose.close(true);
                throw ExceptionUtil.as(SQLException.class, e);
            }
        }
        return new Pair<Boolean, Object>(false, null);
    }

    /*
     * Loose catch block
     */
    private ResultSet syncExecute(SQLInfo si) throws SQLException {
        XDBLog.logSharding(si, this.executionContext.isForManager(), null);
        Connection con = null;
        String mainRoute = this.executionContext.getDbRoute();
        String curRoute = StringUtils.isEmpty((String)si.getDbRoute()) ? mainRoute : si.getDbRoute();
        try (StatTimeStamp ss = this.executionContext.getMetrics().collectExecuteSpent();){
            con = XDBConnection.get().requireConnection(null, this.executionContext, this.errorClose, mainRoute, curRoute);
            PreparedStatement ps = XDBPrepareStatement.get().prepareStatement(this.errorClose, con, si.getSql(), this.executionContext.getQueryTimeoutSeconds(), this.executionContext.getMetrics());
            if (XDBConfig.paramUseOpenGaussFiller()) {
                ParameterFillerFactory.get(ConnectionProvider.get().getConnectionHolder().getDBType()).fill(si.isShardingSQL(), ps, si.getParams());
            } else {
                ParameterSetter.fill(si.isShardingSQL(), ps, si.getParams());
            }
            ResultSet rs = ResultSetFactory.get(ps, new QueryConnHolder(con, this.executionContext.getConnectionHolder(), curRoute));
            if (si.isShardingSQL()) {
                rs = FetchedResultSet.fetch(rs, XDBConfig.get().getFetchSize());
            }
            ResultSet resultSet = rs;
            if (con != null) {
                XDBConnection.get().releaseConnectionForQuery(curRoute, con, this.executionContext.getConnectionHolder());
            }
            return resultSet;
        }
        {
            catch (Throwable throwable) {
                if (con != null) {
                    XDBConnection.get().releaseConnectionForQuery(curRoute, con, this.executionContext.getConnectionHolder());
                }
                throw throwable;
            }
        }
    }

    private Future<ResultSet> asyncExecute(SQLInfo si, ParallelTag tag, Semaphore sp) throws SQLException {
        String mainRoute = this.executionContext.getDbRoute();
        String curRoute = StringUtils.isEmpty((String)si.getDbRoute()) ? mainRoute : si.getDbRoute();
        try {
            sp.acquire();
            XDBConnection.getGlobalParallelSizeSemaphore(curRoute).acquire();
        }
        catch (InterruptedException e) {
            throw ExceptionUtil.as(SQLException.class, e);
        }
        ParallelExecuteContext pec = this.executionContext.getParallelExecuteContext();
        Object isCheck = KSQLThreadCache.get((Object)"check.selectAllColumn");
        ThreadRouteKeyContext routeKeyContext = ThreadRouteKeyContext.get();
        return ParallelExecutor.submit(() -> {
            ResultSet resultSet;
            Throwable throwable;
            StatTimeStamp ss;
            ThreadRouteKeyContext context;
            Connection con;
            block24: {
                if (XDBConfig.get().isEnableParallelExecute()) {
                    ParallelExecutor.setupParallelThreadContext(tag, pec, this.executionContext.getMetrics());
                }
                ShardingStats shardingSql = ShardingStats.create();
                shardingSql.setOriginalSQL(this.executionContext.getOriginalSQL());
                shardingSql.setShardingCount(this.executionContext.getSqlInfos().length);
                con = null;
                if (isCheck != null) {
                    KSQLThreadCache.put((Object)"check.selectAllColumn", (Object)isCheck);
                }
                context = null;
                if (routeKeyContext != null) {
                    context = ThreadRouteKeyContext.create((String)routeKeyContext.getRouteKey());
                }
                ss = this.executionContext.getMetrics().collectExecuteSpentSync();
                throwable = null;
                con = XDBConnection.get().requireConnection(tag, this.executionContext, this.errorClose, mainRoute, curRoute);
                PreparedStatement ps = XDBPrepareStatement.get().prepareStatement(this.errorClose, con, si.getSql(), this.executionContext.getQueryTimeoutSeconds(), this.executionContext.getMetrics());
                if (XDBConfig.paramUseOpenGaussFiller()) {
                    ParameterFillerFactory.get(ConnectionProvider.get().getConnectionHolder().getDBType()).fill(si.isShardingSQL(), ps, si.getParams());
                } else {
                    ParameterSetter.fill(si.isShardingSQL(), ps, si.getParams());
                }
                ResultSet rs = ResultSetFactory.get(ps, new QueryConnHolder(con, this.executionContext.getConnectionHolder(), curRoute));
                if (si.isShardingSQL()) {
                    rs = FetchedResultSet.fetch(rs, XDBConfig.get().getFetchSize());
                }
                resultSet = rs;
                XDBConnection.get().releaseConnectionForQuery(curRoute, con, this.executionContext.getConnectionHolder());
                XDBConnection.getGlobalParallelSizeSemaphore(curRoute).release();
                sp.release();
                if (!XDBConfig.get().isEnableParallelExecute()) break block24;
                ParallelExecutor.clearParallelThreadContext(tag, pec);
            }
            if (context != null) {
                context.close();
            }
            return resultSet;
            {
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ss != null) {
                        if (throwable != null) {
                            try {
                                ss.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ss.close();
                        }
                    }
                }
                {
                    catch (Throwable throwable4) {
                        XDBConnection.get().releaseConnectionForQuery(curRoute, con, this.executionContext.getConnectionHolder());
                        XDBConnection.getGlobalParallelSizeSemaphore(curRoute).release();
                        sp.release();
                        if (XDBConfig.get().isEnableParallelExecute()) {
                            ParallelExecutor.clearParallelThreadContext(tag, pec);
                        }
                        if (context != null) {
                            context.close();
                        }
                        throw throwable4;
                    }
                }
            }
        });
    }
}

