/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.resultset;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.feature.GroupByInfo;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.mergeengine.resultset.ExecutionLazyIterator;
import kd.bos.xdb.mergeengine.resultset.ExecutionLazyResultSet;

public class IteratorQueryDataSet {
    private static final String ALIAS_PREFIX = "lazyload_";
    protected ExecutionLazyResultSet executionLazyResultSet;
    protected DataSet ds;
    protected Row curRow;
    protected Map<Integer, String> dataSetColAliasMap = new HashMap<Integer, String>(16);

    public IteratorQueryDataSet(ExecutionLazyResultSet executionLazyResultSet) throws SQLException {
        this.executionLazyResultSet = executionLazyResultSet;
    }

    public ExecutionLazyResultSet getExecutionLazyResultSet() {
        return this.executionLazyResultSet;
    }

    public void build() {
        try {
            String algoKey = this.getClass().toString();
            ExecutionLazyIterator iterator = new ExecutionLazyIterator(this.executionLazyResultSet);
            RowMeta rowMeta = this.getRowMeta();
            this.ds = Algo.create((String)algoKey).createDataSet((Iterator)iterator, rowMeta);
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.executionLazyResultSet.getResultSet().getMetaData();
    }

    protected RowMeta getRowMeta() {
        try {
            ResultSetMetaData meta = this.getMetaData();
            Field[] fields = new Field[meta.getColumnCount()];
            for (int i = 0; i < fields.length; ++i) {
                int sqlType = meta.getColumnType(i + 1);
                String alais = ALIAS_PREFIX + i;
                this.dataSetColAliasMap.put(i + 1, ALIAS_PREFIX + i);
                fields[i] = new Field(alais, DataType.fromSqlType((int)sqlType), true);
            }
            return new RowMeta(fields);
        }
        catch (SQLException e) {
            throw new AlgoException((Throwable)e);
        }
    }

    public boolean next() {
        boolean hasNest = this.ds.hasNext();
        if (hasNest) {
            this.curRow = this.ds.next();
        }
        return hasNest;
    }

    public Row getRow() {
        return this.curRow;
    }

    public void close() {
        if (this.ds != null) {
            this.ds.close();
        }
    }

    public void groupBy(GroupByInfo gbi) {
        String[] selectFields = this.ds.getRowMeta().getFieldNames();
        String[] groupByFields = this.getGropByFields(gbi);
        GroupbyDataSet gds = this.ds.groupBy(groupByFields);
        int fieldIndex = 0;
        for (SQLSelectItem selectItem : gbi.getSelectItems()) {
            SQLExpr expr = selectItem.getExpr();
            if (expr instanceof SQLAggregateExpr) {
                String aggFunc = ((SQLAggregateExpr)expr).getMethodName().toUpperCase();
                String fieldAlias = ALIAS_PREFIX + fieldIndex;
                switch (aggFunc) {
                    case "SUM": 
                    case "COUNT": {
                        gds = gds.sum(fieldAlias);
                        break;
                    }
                    case "MAX": {
                        gds = gds.max(fieldAlias);
                        break;
                    }
                    case "MIN": {
                        gds = gds.min(fieldAlias);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"AggregateFunctionFactory_0", (String)"\u4e0d\u652f\u6301\u805a\u5408\u51fd\u6570:{0}", (Object[])new Object[]{aggFunc}));
                    }
                }
            }
            ++fieldIndex;
        }
        this.ds = gds.finish();
        this.ds = this.ds.select(selectFields);
    }

    private String[] getGropByFields(GroupByInfo gbi) {
        List<GroupByInfo.GroupByItem> groupByItems = gbi.getGroupByItems();
        int size = groupByItems.size();
        String[] groupByFields = new String[size];
        for (int i = 0; i < size; ++i) {
            groupByFields[i] = this.dataSetColAliasMap.get(groupByItems.get(i).getIndex());
            if (groupByFields[i] != null) continue;
            throw new IllegalArgumentException("Select fields should include group by items.");
        }
        return groupByFields;
    }

    public void orderBy(OrderByInfo obi) {
        String[] orderByFields = this.getOrderByFields(obi);
        this.ds = this.ds.orderBy(orderByFields);
    }

    private String[] getOrderByFields(OrderByInfo obi) {
        List<OrderByInfo.OrderByItem> items = obi.getOrderByItems();
        String[] orderByFields = new String[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            orderByFields[i] = this.dataSetColAliasMap.get(items.get(i).getIndex()) + (items.get(i).isAsc() ? " asc" : " desc");
        }
        return orderByFields;
    }

    public void distinct() {
        this.ds = this.ds.distinct();
    }
}

