/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.single;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import kd.bos.xdb.AutoCloseSet;
import kd.bos.xdb.ParameterSetter;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBLog;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.jdbc.connection.XDBConnection;
import kd.bos.xdb.jdbc.statement.XDBPrepareStatement;
import kd.bos.xdb.merge.ResultSetFactory;
import kd.bos.xdb.merge.WrapCloseResultSet;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.SkipResultSet;
import kd.bos.xdb.merge.resultset.fetched.FetchedResultSet;
import kd.bos.xdb.mergeengine.AbstractMergeEngine;
import kd.bos.xdb.mergeengine.ExecutionContext;
import kd.bos.xdb.mergeengine.iterator.IteratorMergeSet;
import kd.bos.xdb.mergeengine.resultset.ExecutionLazyResultSet;
import kd.bos.xdb.parameter.ParameterFillerFactory;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.xpm.metrics.action.merge.MergeFeatureSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;
import kd.bos.xdb.xpm.metrics.collector.StatTimeStamp;

public class SingleMergeEngineImpl
extends AbstractMergeEngine {
    /*
     * Loose catch block
     */
    @Override
    public ResultSet merge(ExecutionContext executionContext) throws SQLException {
        AutoCloseSet autoCloseSet = new AutoCloseSet();
        MetricsCollector mc = executionContext.getMetrics();
        Connection con = null;
        try (StatTimeStamp ss = mc.collectExecuteSpent();){
            SQLInfo si = executionContext.getSqlInfos()[0];
            XDBLog.logSharding(si, executionContext.isForManager(), null);
            con = XDBConnection.get().requireConnection(executionContext, autoCloseSet);
            PreparedStatement ps = XDBPrepareStatement.get().prepareStatement(autoCloseSet, con, si.getSql(), executionContext.getQueryTimeoutSeconds(), mc);
            if (XDBConfig.paramUseOpenGaussFiller()) {
                ParameterFillerFactory.get(ConnectionProvider.get().getConnectionHolder().getDBType()).fill(si.isShardingSQL(), ps, si.getParams());
            } else {
                ParameterSetter.fill(si.isShardingSQL(), ps, si.getParams());
            }
            ResultSet rs = ResultSetFactory.get(ps, null);
            if (si.isShardingSQL()) {
                rs = FetchedResultSet.fetch(rs, XDBConfig.get().getFetchSize());
            }
            if (executionContext.getSelectFeature() != null && executionContext.getSelectFeature().hasLimit()) {
                rs = new SkipResultSet(rs, executionContext.getSelectFeature().getOffset());
            }
            WrapCloseResultSet wrapCloseResultSet = new WrapCloseResultSet(rs, () -> this.close(autoCloseSet, false));
            if (con != null) {
                XDBConnection.get().releaseConnectionForQuery(con, executionContext);
            }
            return wrapCloseResultSet;
        }
        {
            catch (Throwable throwable) {
                if (con != null) {
                    XDBConnection.get().releaseConnectionForQuery(con, executionContext);
                }
                throw throwable;
            }
        }
    }

    @Override
    public MergeSet doMerge(ExecutionContext executionContext) throws SQLException {
        MergeFeatureSpan mspan;
        SelectFeature sf = executionContext.getSelectFeature();
        IteratorMergeSet iteratorMergeSet = new IteratorMergeSet(new ExecutionLazyResultSet(executionContext));
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isPerformanceMetricEnabled()) {
            mspan = new MergeFeatureSpan(sf);
            mspan.addMergePath(IteratorMergeSet.class.getSimpleName());
            mc.actionMetric().stat(mspan);
        } else {
            mspan = MergeFeatureSpan.blackHole();
        }
        return this.topDecorate(sf, iteratorMergeSet, mspan);
    }
}

