/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.parameter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.xdb.ext.SelfSetParameter;
import kd.bos.xdb.parameter.AbstractParameterFiller;
import kd.bos.xdb.parameter.ParameterFiller;
import kd.bos.xdb.parameter.common.ArrayFiller;
import kd.bos.xdb.parameter.common.BigDecimalFiller;
import kd.bos.xdb.parameter.common.BigIntegerFiller;
import kd.bos.xdb.parameter.common.BooleanFiller;
import kd.bos.xdb.parameter.common.ByteFiller;
import kd.bos.xdb.parameter.common.BytesFiller;
import kd.bos.xdb.parameter.common.DateFiller;
import kd.bos.xdb.parameter.common.DoubleFiller;
import kd.bos.xdb.parameter.common.FloatFiller;
import kd.bos.xdb.parameter.common.ObjectFiller;
import kd.bos.xdb.parameter.common.SelfSetParameterFiller;
import kd.bos.xdb.parameter.common.ShortFiller;
import kd.bos.xdb.parameter.common.StringFiller;
import kd.bos.xdb.parameter.common.TimestampFiller;
import kd.bos.xdb.parameter.opengauss.IntegerFiller;
import kd.bos.xdb.parameter.opengauss.LongFiller;

public class OpenGaussParameterFiller
extends AbstractParameterFiller {
    private static final Map<Class<?>, ParameterFiller> fillerCache = new ConcurrentHashMap();
    private static final BytesFiller bytesFiller = new BytesFiller();
    private static final ArrayFiller arrayFiller = new ArrayFiller();

    @Override
    public final void set(PreparedStatement stmt, Object value, int index) throws SQLException {
        if (null == value) {
            stmt.setNull(index, 0);
        } else {
            this.getFiller(value.getClass()).doFill(stmt, value, index, 1111);
        }
    }

    @Override
    public final void set(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
        if (null == value) {
            stmt.setNull(index, 0);
        } else {
            switch (sqlType) {
                case -5: {
                    fillerCache.get(Long.class).doFill(stmt, value, index, sqlType);
                    break;
                }
                case 4: {
                    fillerCache.get(Integer.class).doFill(stmt, value, index, sqlType);
                    break;
                }
                default: {
                    this.getFiller(value.getClass()).doFill(stmt, value, index, sqlType);
                }
            }
        }
    }

    @Override
    protected final ParameterFiller getFiller(Class<?> p) {
        if (p == Object.class || p == Long.class || p == Long.TYPE || p == Integer.class || p == Integer.TYPE || p == BigDecimal.class || p == Boolean.class || p == Boolean.TYPE || p == Timestamp.class) {
            return fillerCache.get(p);
        }
        if (p == String.class || p == Character.class || p == Character.TYPE || Enum.class.isAssignableFrom(p)) {
            return fillerCache.get(String.class);
        }
        if (java.util.Date.class.isAssignableFrom(p)) {
            return fillerCache.get(java.util.Date.class);
        }
        if (SelfSetParameter.class.isAssignableFrom(p)) {
            return fillerCache.get(SelfSetParameter.class);
        }
        if (p == byte[].class) {
            return bytesFiller;
        }
        if (p.isArray() || Iterable.class.isAssignableFrom(p)) {
            return arrayFiller;
        }
        ParameterFiller ps = fillerCache.get(p);
        if (ps == null) {
            for (Class<?> pcls = p.getSuperclass(); pcls != null; pcls = pcls.getSuperclass()) {
                ps = fillerCache.get(pcls);
                if (ps == null) continue;
                fillerCache.put(pcls, ps);
                fillerCache.put(p, ps);
                break;
            }
            if (ps == null) {
                ps = new ObjectFiller();
                fillerCache.put(p.getClass(), ps);
            }
        }
        return ps;
    }

    static {
        SelfSetParameterFiller selfFiller = new SelfSetParameterFiller();
        fillerCache.put(SelfSetParameter.class, selfFiller);
        ByteFiller byteFiller = new ByteFiller();
        fillerCache.put(Byte.class, byteFiller);
        fillerCache.put(Byte.TYPE, byteFiller);
        DateFiller dateFiller = new DateFiller();
        fillerCache.put(java.util.Date.class, dateFiller);
        fillerCache.put(Date.class, dateFiller);
        TimestampFiller timestampFiller = new TimestampFiller();
        fillerCache.put(Timestamp.class, timestampFiller);
        BooleanFiller booleanFiller = new BooleanFiller();
        fillerCache.put(Boolean.class, booleanFiller);
        fillerCache.put(Boolean.TYPE, booleanFiller);
        DoubleFiller doubleFiller = new DoubleFiller();
        fillerCache.put(Double.class, doubleFiller);
        fillerCache.put(Double.TYPE, doubleFiller);
        FloatFiller floatFiller = new FloatFiller();
        fillerCache.put(Float.class, floatFiller);
        fillerCache.put(Float.TYPE, floatFiller);
        ShortFiller shortFiller = new ShortFiller();
        fillerCache.put(Short.class, shortFiller);
        fillerCache.put(Short.TYPE, shortFiller);
        ObjectFiller objectFiller = new ObjectFiller();
        fillerCache.put(Object.class, objectFiller);
        StringFiller stringFiller = new StringFiller();
        fillerCache.put(Character.TYPE, stringFiller);
        fillerCache.put(Character.class, stringFiller);
        fillerCache.put(String.class, stringFiller);
        fillerCache.put(Enum.class, stringFiller);
        BigDecimalFiller bigDecimalFiller = new BigDecimalFiller();
        fillerCache.put(BigDecimal.class, bigDecimalFiller);
        fillerCache.put(BigInteger.class, new BigIntegerFiller());
        LongFiller longFiller = new LongFiller();
        IntegerFiller integerFiller = new IntegerFiller();
        fillerCache.put(Integer.class, integerFiller);
        fillerCache.put(Integer.TYPE, integerFiller);
        fillerCache.put(Long.class, longFiller);
        fillerCache.put(Long.TYPE, longFiller);
    }
}

