/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.xdb.exception.ExceptionUtil;

public class KSQLTimePatternFormatter {
    private boolean isKSQLTimePattern;
    private String ksqlTimePattern;
    private int year = 0;
    private int month = 0;
    private int day = 0;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private static final String[] wordKeys = new String[]{"d", "t", "ts"};

    public KSQLTimePatternFormatter(String ksqlTimePattern) {
        this.ksqlTimePattern = ksqlTimePattern;
        this.initFormat(ksqlTimePattern);
    }

    private void initFormat(String formatString) {
        char[] chars = formatString.trim().toCharArray();
        int length = chars.length;
        if (length > 0) {
            ArrayList<String> segments = new ArrayList<String>();
            if (chars[0] == '{' && chars[length - 1] == '}') {
                StringBuilder s = new StringBuilder(24);
                for (int i = 1; i < length; ++i) {
                    char ch = chars[i];
                    if (ch == ' ' || ch == '}' || ch == '\'') {
                        String ad = s.toString();
                        if (ad.trim().length() == 0) continue;
                        segments.add(ad);
                        s.setLength(0);
                        continue;
                    }
                    s.append(ch);
                }
                if (!segments.isEmpty()) {
                    String wordType = ((String)segments.get(0)).toLowerCase();
                    try {
                        String[] ymdSplit;
                        if (wordKeys[0].equals(wordType)) {
                            this.validateSegment(segments, wordType);
                            this.isKSQLTimePattern = true;
                            String ymd = (String)segments.get(1);
                            ymdSplit = ymd.split("-");
                            if (ymdSplit.length != 2) {
                                throw ExceptionUtil.asRuntimeException(new RuntimeException("Uncorrected KSQLTimeFormatPattern :" + this.ksqlTimePattern));
                            }
                            this.year = Integer.parseInt(ymdSplit[0]);
                            this.month = Integer.parseInt(ymdSplit[1]);
                            this.day = Integer.parseInt(ymdSplit[2]);
                        } else if (wordKeys[1].equals(wordType)) {
                            this.validateSegment(segments, wordType);
                            this.isKSQLTimePattern = true;
                            String hms = (String)segments.get(1);
                            String[] hmsSplit = hms.split(":");
                            if (hmsSplit.length != 2) {
                                throw ExceptionUtil.asRuntimeException(new RuntimeException("Uncorrected KSQLTimeFormatPattern :" + this.ksqlTimePattern));
                            }
                            this.hour = Integer.parseInt(hmsSplit[0]);
                            this.minute = Integer.parseInt(hmsSplit[1]);
                            this.second = Integer.parseInt(hmsSplit[2]);
                        } else if (wordKeys[2].equals(wordType)) {
                            this.validateSegment(segments, wordType);
                            this.isKSQLTimePattern = true;
                            String ymd = (String)segments.get(1);
                            ymdSplit = ymd.split("-");
                            if (ymdSplit.length != 3) {
                                throw ExceptionUtil.asRuntimeException(new RuntimeException("Uncorrected KSQLTimeFormatPattern :" + this.ksqlTimePattern));
                            }
                            this.year = Integer.parseInt(ymdSplit[0]);
                            this.month = Integer.parseInt(ymdSplit[1]);
                            this.day = Integer.parseInt(ymdSplit[2]);
                            String hms = (String)segments.get(2);
                            String[] hmsSplit = hms.split(":");
                            if (hmsSplit.length != 3) {
                                throw ExceptionUtil.asRuntimeException(new RuntimeException("Uncorrected KSQLTimeFormatPattern :" + this.ksqlTimePattern));
                            }
                            this.hour = Integer.parseInt(hmsSplit[0]);
                            this.minute = Integer.parseInt(hmsSplit[1]);
                            this.second = Integer.parseInt(hmsSplit[2]);
                        }
                    }
                    catch (Exception e) {
                        throw ExceptionUtil.asRuntimeException("Uncorrected KSQLTimeFormatPattern :" + this.ksqlTimePattern, e);
                    }
                }
            }
        }
    }

    private void validateSegment(List<String> segments, String wordType) {
        switch (wordType) {
            case "t": 
            case "d": {
                if (segments.size() <= 2) break;
                throw ExceptionUtil.asRuntimeException(new RuntimeException("Uncorrected KSQLTimeFormatPattern :" + this.ksqlTimePattern));
            }
            case "ts": {
                if (segments.size() <= 3) break;
                throw ExceptionUtil.asRuntimeException(new RuntimeException("Uncorrected KSQLTimeFormatPattern :" + this.ksqlTimePattern));
            }
            default: {
                throw ExceptionUtil.asRuntimeException(new RuntimeException("Uncorrected KSQLTimeFormatPattern :" + this.ksqlTimePattern));
            }
        }
    }

    public boolean isKSQLTimePattern() {
        return this.isKSQLTimePattern;
    }

    public Date getKSQLTimePatternToDate() {
        Calendar cale = Calendar.getInstance();
        cale.set(this.year, this.month, this.day, this.hour, this.minute, this.second);
        cale.set(14, 0);
        return cale.getTime();
    }

    public static void main(String[] args) {
        KSQLTimePatternFormatter k = new KSQLTimePatternFormatter(" { ts ' 2020-10-26 06:06:06 ' } ");
        System.out.println(k.getKSQLTimePatternToDate());
    }
}

