/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.config;

import kd.bos.xdb.sharding.config.AttributeEnum;
import kd.bos.xdb.sharding.config.BaseShardingConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.children.ChildrenStrategy;

public class ChildrenTableConfig
extends BaseShardingConfig
implements ShardingConfig {
    private String name;
    private boolean enabled = true;
    private String table;
    private String joinField;
    private String parentField;
    private boolean hasChildren;
    private ShardingConfig parent;
    private ChildrenStrategy strategy;
    private final String[] shardingFields;

    ChildrenTableConfig(String name, String table, String joinField, String parentField, ShardingConfig parent, boolean isMock) {
        this.name = name;
        this.level = parent.getLevel() + 1;
        this.parent = parent;
        this.table = table.toLowerCase();
        this.joinField = joinField.toLowerCase();
        this.parentField = parentField.toLowerCase();
        this.shardingFields = new String[]{this.joinField};
        this.pkField = this.joinField;
        if (parent instanceof ChildrenTableConfig) {
            ((ChildrenTableConfig)parent).setHasChildren(true);
        }
        this.entityNumber = parent.getEntitynumber();
        ShardingConfig sc = parent;
        while (!(sc instanceof MainTableConfig)) {
            sc = ((ChildrenTableConfig)sc).parent;
        }
        ((MainTableConfig)sc).addGroupTable(this.table);
        this.strategy = new ChildrenStrategy();
        this.strategy.setIndexPK(parent.isIndexPK());
        this.strategy.setPKField(((AbstractShardingStrategy)parent.getShardingStrategy()).getPKField());
        if (!isMock) {
            this.strategy.initConfig(this);
        }
        ((BaseShardingConfig)parent).childrenConfigMap.put(name + '#' + table, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String[] getShardingFields() {
        return this.shardingFields;
    }

    public ShardingConfig getParent() {
        return this.parent;
    }

    @Override
    public ShardingStrategy getShardingStrategy() {
        return this.strategy;
    }

    public String getJoinField() {
        return this.joinField;
    }

    public String getParentField() {
        return this.parentField;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return this.table + "." + this.joinField + "=" + this.parent.getTable() + "." + this.parentField;
    }

    @Override
    public final boolean isIndexPK() {
        return this.parent.isIndexPK();
    }

    @Override
    public void setIndexPK(boolean indexPK) {
        this.parent.setIndexPK(indexPK);
    }

    public boolean isHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public boolean isLangTableConfig() {
        Boolean b = (Boolean)this.getAttribute(AttributeEnum.is_lang_table.name());
        return b != null && b != false;
    }

    public void setLangTableConfig() {
        this.setAttribute(AttributeEnum.is_lang_table.name(), Boolean.TRUE);
        this.setParentPkField();
    }

    public boolean isGroupTableConfig() {
        Boolean b = (Boolean)this.getAttribute(AttributeEnum.is_group_table.name());
        return b != null && b != false;
    }

    public void setGroupTableConfig() {
        this.setAttribute(AttributeEnum.is_group_table.name(), Boolean.TRUE);
        this.setParentPkField();
    }

    public boolean isTcTableConfig() {
        Boolean b = (Boolean)this.getAttribute(AttributeEnum.is_tc_table.name());
        return b != null && b != false;
    }

    public void setTcTableConfig() {
        this.setAttribute(AttributeEnum.is_tc_table.name(), Boolean.TRUE);
        this.setParentPkField();
    }

    public void setPrivacyTableConfig() {
        this.setAttribute(AttributeEnum.is_privacy_table.name(), Boolean.TRUE);
        if (this.parent instanceof ChildrenTableConfig) {
            if (this.parent.getLevel() == 2) {
                ((ChildrenTableConfig)this.parent).setPKField("fentryid");
            } else {
                ((ChildrenTableConfig)this.parent).setPKField("fdetailid");
            }
        }
    }

    public boolean isPrivacyTableConfig() {
        Boolean b = (Boolean)this.getAttribute(AttributeEnum.is_privacy_table.name());
        return b != null && b != false;
    }

    public boolean isWbTableConfig() {
        Boolean b = (Boolean)this.getAttribute(AttributeEnum.is_wb_table.name());
        return b != null && b != false;
    }

    public void setWbTableConfig() {
        this.setAttribute(AttributeEnum.is_wb_table.name(), Boolean.TRUE);
        this.setParentPkField();
    }

    public boolean isLkTableConfig() {
        Boolean b = (Boolean)this.getAttribute(AttributeEnum.is_lk_table.name());
        return b != null && b != false;
    }

    public void setLkTableConfig() {
        this.setAttribute(AttributeEnum.is_lk_table.name(), Boolean.TRUE);
        this.setParentPkField();
    }

    public boolean isEntryTableConfig() {
        return !this.isLangTableConfig() && !this.isGroupTableConfig() && !this.isTcTableConfig() && !this.isWbTableConfig() && !this.isLkTableConfig();
    }

    private void setParentPkField() {
        if (this.parent instanceof ChildrenTableConfig) {
            ((ChildrenTableConfig)this.parent).setPKField(this.joinField);
        }
    }

    @Override
    public void mockSet(String name, String table) {
        this.name = name;
        this.table = table;
    }
}

