/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.config;

import java.util.Map;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.DataRowsRange;
import kd.bos.xdb.sharding.config.FieldDefine;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfigOptions;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;

public interface ShardingConfig {
    public String getEntitynumber();

    public String getName();

    public int getLevel();

    public String[] getShardingFields();

    public boolean isIndexPK();

    public void setIndexPK(boolean var1);

    public String getTable();

    public ShardingStrategy getShardingStrategy();

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public <T> T getAttribute(String var1);

    public <T> void setAttribute(String var1, T var2);

    public Map<String, ShardingConfig> getChildrenConfigMap();

    public ShardingConfigOptions getOptions();

    public static ShardingConfig table(String entityNumber, String name, String table, FieldDefine[] shardingFieldDefines, ShardingStrategy shardingStrategy, DataRowsRange dataRowsRange, IndexDefine[] indexDefines, boolean isMock) {
        return new MainTableConfig(entityNumber, name, table, shardingFieldDefines, shardingStrategy, dataRowsRange, indexDefines, isMock);
    }

    public static ShardingConfig table(String entityNumber, String name, String table, FieldDefine[] shardingFieldDefines, ShardingStrategy shardingStrategy, DataRowsRange dataRowsRange, IndexDefine[] indexDefines) {
        return ShardingConfig.table(entityNumber, name, table, shardingFieldDefines, shardingStrategy, dataRowsRange, indexDefines, false);
    }

    public static ShardingConfig childrenTable(String name, String table, String joinField, String parentField, ShardingConfig parent) {
        return ShardingConfig.childrenTable(name, table, joinField, parentField, parent, false);
    }

    public static ShardingConfig childrenTable(String name, String table, String joinField, String parentField, ShardingConfig parent, boolean isMock) {
        ChildrenTableConfig childrenConfig = new ChildrenTableConfig(name, table, joinField, parentField, parent, isMock);
        childrenConfig.setEnabled(parent.isEnabled());
        return childrenConfig;
    }
}

