/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.indexpk;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBManageContext;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.cache.CacheAction;
import kd.bos.xdb.cache.CacheContext;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.xpm.metrics.action.sharding.pk.BatchInsertIndexPKActionSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public final class BatchInsertIndexPKAction
implements CacheAction {
    private String dbRoute;
    private String sql;
    private List<Object[]> paramsList = new ArrayList<Object[]>();

    public boolean hasSetSQL() {
        return this.sql != null;
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public void setDbRoute(String dbRoute) {
        this.dbRoute = dbRoute;
    }

    public void addBatch(Object[] params) {
        this.paramsList.add(params);
    }

    @Override
    public void commitAction() {
        this.executeBatch();
    }

    private void executeBatch() {
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().stat(new BatchInsertIndexPKActionSpan(this.sql, this.paramsList));
        }
        try (XDBManageContext xm = XDB.get().withManageContext();){
            xm.setRoute(this.dbRoute);
            XDB.get().executeBatch(this.sql, this.paramsList);
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
        finally {
            this.sql = null;
            this.paramsList.clear();
        }
    }

    public static BatchInsertIndexPKAction getOrCreate() {
        return (BatchInsertIndexPKAction)CacheContext.get().getCurrentCache().setIfAbsent("", "BatchInsertIndexPKAction", k -> new BatchInsertIndexPKAction());
    }

    public static void commitActionIfPresent() {
        Cache cc = CacheContext.get().getCurrentCache();
        BatchInsertIndexPKAction action = (BatchInsertIndexPKAction)cc.get("", "BatchInsertIndexPKAction");
        if (action != null) {
            try {
                action.commitAction();
            }
            finally {
                cc.remove("", "BatchInsertIndexPKAction");
            }
        }
    }
}

