/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.indexpk;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManageContext;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.DataRowsRange;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.indexpk.BatchInsertIndexPKAction;
import kd.bos.xdb.sharding.indexpk.IndexPKCache;
import kd.bos.xdb.sharding.indexpk.IndexPKLocalCache;
import kd.bos.xdb.sharding.indexpk.IndexPKVersion;
import kd.bos.xdb.sharding.indexpk.QueryIndexPKAction;
import kd.bos.xdb.sharding.sql.ParamsGroup;
import kd.bos.xdb.tablemanager.PkTypeEnum;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.ArrayUtil;
import kd.bos.xdb.xpm.metrics.action.ActionMetric;
import kd.bos.xdb.xpm.metrics.action.sharding.pk.UpdatePKIndexSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public final class IndexPKStore {
    private static int hearttime = 120000;
    private static final String pkField = "fpk";
    private final IndexPKCache pkCache;
    private final String name;
    private AtomicLong version = new AtomicLong(0L);
    private IndexPKVersion indexPKVersion;
    private long lastUpdateTimes = 0L;

    public IndexPKStore(String name) {
        this.name = name;
        this.pkCache = new IndexPKLocalCache(name);
        this.indexPKVersion = new IndexPKVersion(name);
        this.lastUpdateTimes = System.currentTimeMillis();
        this.version.set(this.indexPKVersion.getLastVersion());
    }

    public void initCacheSize(String tableName) {
        this.pkCache.initCache(tableName);
    }

    public void clear(String ... tableNames) {
        this.pkCache.clear(tableNames);
    }

    public void clearParentPk(String tableName, Object pk) {
        this.pkCache.clearParentPk(tableName, pk);
    }

    public void clearCache(String tableName) {
        ShardingConfig config = XDBConfig.getShardingConfigProvider().getConfig(tableName);
        if (config != null) {
            while (config instanceof ChildrenTableConfig) {
                config = ((ChildrenTableConfig)config).getParent();
            }
            config.getShardingStrategy().clearCache();
            for (ShardingConfig cc : ((MainTableConfig)config).getChildrenConfigMap().values()) {
                cc.getShardingStrategy().clearCache();
            }
        }
    }

    public void setCache(String tableName, long index, Object pk) {
        this.pkCache.set(tableName, index, pk);
    }

    public Long getCache(ActionMetric am, String tableName, Object pk) {
        return this.getCache(am, tableName, new Object[]{pk}).get(pk);
    }

    public Map<Object, Long> getCache(ActionMetric am, String tableName, Object ... pk) {
        long currentTimes = System.currentTimeMillis();
        if (currentTimes - this.lastUpdateTimes > (long)hearttime) {
            this.lastUpdateTimes = currentTimes;
            long lastVersion = -1L;
            lastVersion = this.indexPKVersion.getLastVersion();
            if (this.version.get() != lastVersion) {
                this.clearCache(tableName);
                this.version.set(lastVersion);
                HashMap<Object, Long> ret = new HashMap<Object, Long>(pk.length);
                for (Object p : pk) {
                    ret.put(p, null);
                }
                return ret;
            }
        }
        return this.pkCache.get(am, tableName, pk);
    }

    public void incVersion() {
        this.version.incrementAndGet();
        this.indexPKVersion.incVersion();
    }

    public long[] getOrQueryPKShardingIndex(ActionMetric am, String tableName, Object ... pks) {
        Map<Object, Long> map;
        if (pks.length == 1) {
            if (pks[0] == null) {
                return ArrayUtil.EMPTY_INDEXIES;
            }
            if (pks[0].getClass().isArray()) {
                if (pks[0].getClass() == Object[].class) {
                    pks = (Object[])pks[0];
                } else {
                    Object array = pks[0];
                    int n = Array.getLength(array);
                    pks = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        pks[i] = Array.get(array, i);
                    }
                }
                return this.getOrQueryPKShardingIndex(am, tableName, pks);
            }
            Long v = this.getCache(am, tableName, pks[0]);
            if (v != null) {
                return new long[]{v};
            }
            long[] lret = QueryIndexPKAction._queryShardingIndexWithoutCache(tableName, pkField, pks);
            if (lret.length == 1) {
                this.setCache(tableName, lret[0], pks[0]);
            }
            return lret;
        }
        HashSet<Long> ret = new HashSet<Long>(pks.length);
        ArrayList<Object> noCachePKs = new ArrayList<Object>(pks.length);
        Map<Object, Long> pkIndexMap = this.getCache(am, tableName, pks);
        for (Map.Entry<Object, Long> entry : pkIndexMap.entrySet()) {
            Long index = entry.getValue();
            if (index != null) {
                ret.add(index);
                continue;
            }
            noCachePKs.add(entry.getKey());
        }
        if (!noCachePKs.isEmpty() && !(map = QueryIndexPKAction._queryShardingIndexWithoutCache(tableName, noCachePKs)).isEmpty()) {
            ret.addAll(map.values());
            for (Map.Entry<Object, Long> entry : map.entrySet()) {
                this.setCache(tableName, entry.getValue(), entry.getKey());
            }
        }
        return ArrayUtil.toArray(ret);
    }

    public void insertPKShardingIndex(String dbRoute, String tableName, long index, String pkField, IndexDefine[] indexDefines, ParamsGroup pg) {
        Object[] params;
        StringBuilder sql;
        Object pk = pg.get(pg.keys(pkField).iterator().next()).get(0);
        BatchInsertIndexPKAction action = BatchInsertIndexPKAction.getOrCreate();
        boolean buildSQL = !action.hasSetSQL();
        StringBuilder stringBuilder = sql = buildSQL ? new StringBuilder(256).append("insert into ").append(TableName.of(tableName).getPKTable()).append("(findex,fpk") : null;
        if (indexDefines != null && indexDefines.length > 0) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(index);
            list.add(pk);
            int indexCount = 0;
            for (IndexDefine def : indexDefines) {
                Set<ParamsGroup.ParameterKey> fieldP = pg.keys(def.getField());
                if (fieldP.isEmpty()) continue;
                if (buildSQL) {
                    sql.append(',').append(def.getField());
                }
                list.add(pg.get(fieldP.iterator().next()).get(0));
                ++indexCount;
            }
            if (buildSQL) {
                sql.append(") values (?,?");
                for (int i = 0; i < indexCount; ++i) {
                    sql.append(',').append('?');
                }
                sql.append(')');
            }
            params = list.toArray();
        } else {
            if (buildSQL) {
                sql.append(") values (?,?)");
            }
            params = new Object[]{index, pk};
        }
        if (buildSQL) {
            action.setDbRoute(dbRoute);
            action.setSQL(KSQL.dialect(NoShardingHint.genNoShardingSQL(sql.toString())));
        }
        action.addBatch(params);
        this.setCache(tableName, index, pk);
    }

    public void updatePKShardingIndex(String tableName, long index, Object pk) {
        String sql = NoShardingHint.genNoShardingSQL("update " + TableName.of(tableName).getPKTable() + " set findex=? where fpk=?");
        sql = KSQL.dialect(sql);
        String indexDbRoute = XDBConfig.getShardingConfigProvider().getMainConfig(tableName).getOptions().getIndexRoute().getRoute(index);
        try (XDBManageContext xm = XDB.get().withManageContext();){
            xm.setRoute(indexDbRoute);
            XDB.get().execute(sql, index, pk);
            this.setCache(tableName, index, pk);
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().stat(new UpdatePKIndexSpan(tableName, pk, index));
        }
    }

    public long[] queryShardingIndexWithCompare(String tableName, String cp, Object pk) {
        return QueryIndexPKAction._queryShardingIndexWithCompare(tableName, cp, pk);
    }

    public String toString() {
        return this.name;
    }

    public static void ensureCreatePKTable(ShardingConfig config, String pkTable, PkTypeEnum type, DataRowsRange drr, IndexDefine[] indexDefines) {
        if (config instanceof MainTableConfig) {
            try {
                if (!XDBConfig.getTableManager().existTable(pkTable) && null != type) {
                    XDBConfig.getTableManager().createPKTable(ExtContext.get().getDBRoute(), pkTable, type, drr, indexDefines);
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(e);
            }
        }
    }

    static {
        ConfigurationUtil.observeInteger((String)"xdb.indexpk.heart.time", (int)hearttime, v -> {
            hearttime = v;
        });
    }
}

