/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.indexpk;

import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.eventbus.RequestContextInfo;

public final class IndexPKVersion {
    private static int timeout = 120;
    private final String name;
    private final String accountKey;
    private DistributeCacheHAPolicy distributeCacheHAPolicy = new DistributeCacheHAPolicy(true, false);
    private DistributeSessionlessCache pkVersionCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("XDB", this.distributeCacheHAPolicy);

    public IndexPKVersion(String name) {
        RequestContextInfo rc = RequestContextInfo.get();
        this.accountKey = rc.getTenantId() + '#' + rc.getAccountId();
        this.name = name;
    }

    public long getLastVersion() {
        String version = (String)this.pkVersionCache.get(this.getIndexPKVersionKey());
        if (version != null) {
            try {
                return Long.parseLong(version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        long cur = System.currentTimeMillis();
        this.pkVersionCache.put(this.getIndexPKVersionKey(), (Object)String.valueOf(cur), timeout, TimeUnit.MINUTES);
        return cur;
    }

    public long incVersion() {
        return this.pkVersionCache.inc(this.getIndexPKVersionKey(), timeout, TimeUnit.MINUTES);
    }

    private final String getIndexPKVersionKey() {
        return "XDB#IndexPKVersion#" + this.accountKey + '#' + this.name;
    }

    static {
        ConfigurationUtil.observeInteger((String)"xdb.indexpk.version.timeout", (int)timeout, v -> {
            timeout = v;
        });
    }
}

