/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql;

import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.condition.ConditionShardingSQL;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;

public class FinalShardingSQL
extends ShardingSQL {
    private final SQLInfo sqlInfo;

    public static SQLInfo finallyShardingSQL(ShardingSQL ss) {
        Object[] params;
        SQLInfo si = ss.getSQLInfo();
        if (ss instanceof ConditionShardingSQL && (params = si.getParams()) != null) {
            boolean shouldExpandIn = false;
            for (Object param : params) {
                if (param == null || !(param instanceof Iterable) && !param.getClass().isArray()) continue;
                shouldExpandIn = true;
                break;
            }
            if (shouldExpandIn) {
                si = ((ConditionShardingSQL)ss).genNoShardingSQL();
            }
        }
        return si;
    }

    public FinalShardingSQL(StatementInfo stmtInfo) {
        ShardingSQL ss = stmtInfo.shardingSQL();
        if (ss instanceof ConditionShardingSQL) {
            this.sqlInfo = ((ConditionShardingSQL)ss).genNoShardingSQL();
        } else {
            this.sqlInfo = new SQLInfo(stmtInfo.getSQLStatement().toString(), stmtInfo.getSQLInfo().getParams(), true);
            this.sqlInfo.setShardingHintContext(stmtInfo.getSQLInfo().getShardingHintContext());
        }
    }

    public FinalShardingSQL(SQLInfo sqlInfo, String shardingTable) {
        this.sqlInfo = sqlInfo;
        this.addShardingTable(shardingTable);
    }

    protected FinalShardingSQL(SQLInfo sqlInfo, List<String> shardingTables) {
        this.sqlInfo = sqlInfo;
        this.addShardingTables(shardingTables);
    }

    @Override
    public SQLInfo getSQLInfo() {
        return this.sqlInfo;
    }

    @Override
    public String toString() {
        return this.sqlInfo.toString();
    }

    @Override
    public boolean canSharding() {
        return false;
    }

    @Override
    public ShardingSQL[] sharding(TableInfo shardingSourceTable, ShardingStrategy strategy) {
        throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"FinalShardingSQL_0", (String)"{0}\u4e0d\u53ef\u518d\u5206\u7247:{1} ", (Object[])new Object[]{shardingSourceTable, this.sqlInfo}));
    }
}

