/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;
import kd.bos.bundle.Resources;
import kd.bos.xdb.sharding.sql.visitor.PropertyVisitor;

public class PropertyInfo {
    private SQLExprTableSource tableSource;
    private String field;

    public static PropertyInfo of(SQLExpr expr, boolean pureProperty) {
        if (pureProperty) {
            if (expr instanceof SQLIdentifierExpr) {
                return new PropertyInfo((SQLIdentifierExpr)expr);
            }
            if (expr instanceof SQLPropertyExpr) {
                return new PropertyInfo((SQLPropertyExpr)expr);
            }
            throw new UnsupportedOperationException(Resources.get((String)"bos-xdb", (String)"PropertyInfo_0", (String)"\u5c5e\u6027\u4e0d\u80fd\u4e3a\u8868\u8fbe\u5f0f:{0} ", (Object[])new Object[]{expr}));
        }
        PropertyVisitor pv = new PropertyVisitor();
        expr.accept((SQLASTVisitor)pv);
        List<PropertyInfo> pis = pv.getPropertyInfos();
        if (pis.size() != 1) {
            throw new UnsupportedOperationException(Resources.get((String)"bos-xdb", (String)"PropertyInfo_0", (String)"\u5c5e\u6027\u4e0d\u80fd\u4e3a\u8868\u8fbe\u5f0f:{0} ", (Object[])new Object[]{expr}));
        }
        PropertyInfo pi = pis.get(0);
        return pi;
    }

    public PropertyInfo(SQLIdentifierExpr expr) {
        this((SQLExprTableSource)expr.getResolvedOwnerObject(), expr.toString());
    }

    public PropertyInfo(SQLPropertyExpr expr) {
        this((SQLExprTableSource)expr.getResolvedOwnerObject(), expr.getName());
    }

    public PropertyInfo(SQLExprTableSource tableSource, String field) {
        this.tableSource = tableSource;
        this.field = field.toLowerCase();
    }

    public SQLExprTableSource getTableSource() {
        return this.tableSource;
    }

    public String getField() {
        return this.field;
    }

    public String toString() {
        return this.tableSource + "." + this.field;
    }
}

