/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.condition;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLTextLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import java.util.HashSet;
import java.util.function.Function;
import kd.bos.xdb.sharding.sql.condition.ConditionExprList;
import kd.bos.xdb.sharding.sql.condition.eval.Evalor;
import kd.bos.xdb.sharding.sql.condition.eval.PrimaryExecutor;
import kd.bos.xdb.sharding.sql.condition.eval.SQLExprEvalorGenner;

public enum AlwaysValue {
    always_true,
    always_false,
    always_none;


    public static AlwaysValue of(ConditionExprList ce, Function<Integer, Object> varRefValueProvider) {
        if (ce.getExprList().isEmpty()) {
            return always_true;
        }
        if (Boolean.getBoolean("xdb.uncondition")) {
            return always_none;
        }
        HashSet<AlwaysValue> retSet = new HashSet<AlwaysValue>(16);
        for (SQLExpr conditionExpr : ce.getExprList()) {
            retSet.add(AlwaysValue.testAlways(conditionExpr, varRefValueProvider));
        }
        if (retSet.size() == 1) {
            return (AlwaysValue)((Object)retSet.iterator().next());
        }
        return always_none;
    }

    static AlwaysValue testAlways(SQLExpr conditionExpr, final Function<Integer, Object> varRefValueProvider) {
        SQLExprEvalorGenner conditionEval = new SQLExprEvalorGenner(conditionExpr);
        Evalor executor = conditionEval.gen();
        boolean alwaysTrue = executor.eval(new PrimaryExecutor(){

            @Override
            public boolean effective(SQLExpr expr) {
                AlwaysValue ret;
                if (expr instanceof SQLBinaryOpExpr && (ret = AlwaysValue.testAlways((SQLBinaryOpExpr)expr, (Function<Integer, Object>)varRefValueProvider)) == always_true) {
                    SQLObject parent = expr.getParent();
                    return !(parent instanceof SQLBinaryOpExpr) || ((SQLBinaryOpExpr)parent).getOperator() != SQLBinaryOperator.BooleanOr;
                }
                return false;
            }
        });
        if (alwaysTrue) {
            return always_true;
        }
        boolean alwaysFalse = executor.eval(new PrimaryExecutor(){

            @Override
            public boolean effective(SQLExpr expr) {
                AlwaysValue ret;
                if (expr instanceof SQLBinaryOpExpr && (ret = AlwaysValue.testAlways((SQLBinaryOpExpr)expr, (Function<Integer, Object>)varRefValueProvider)) == always_false) {
                    SQLObject parent = expr.getParent();
                    return !(parent instanceof SQLBinaryOpExpr) || ((SQLBinaryOpExpr)parent).getOperator() != SQLBinaryOperator.BooleanOr;
                }
                return false;
            }

            @Override
            public boolean antiNoEffective() {
                return true;
            }
        });
        if (alwaysFalse) {
            return always_false;
        }
        return always_none;
    }

    private static AlwaysValue testAlways(SQLBinaryOpExpr expr, Function<Integer, Object> varRefValueProvider) {
        Object right;
        Object left = AlwaysValue.getExprValue(expr.getLeft(), varRefValueProvider);
        if (left != null && (right = AlwaysValue.getExprValue(expr.getRight(), varRefValueProvider)) != null) {
            SQLBinaryOperator op = expr.getOperator();
            if (left.equals(right) || String.valueOf(left).equals(String.valueOf(right))) {
                return op == SQLBinaryOperator.Equality ? always_true : always_false;
            }
            return op == SQLBinaryOperator.Equality ? always_false : always_true;
        }
        return always_none;
    }

    private static Object getExprValue(SQLExpr expr, Function<Integer, Object> varRefValueProvider) {
        if (expr instanceof SQLVariantRefExpr) {
            return varRefValueProvider.apply(((SQLVariantRefExpr)expr).getIndex());
        }
        if (expr instanceof SQLIntegerExpr) {
            return ((SQLIntegerExpr)expr).getNumber();
        }
        if (expr instanceof SQLTextLiteralExpr) {
            return ((SQLTextLiteralExpr)expr).getText();
        }
        return null;
    }
}

