/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.ddl;

import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.sharding.config.ShardingIndexRoute;
import kd.bos.xdb.sharding.sql.FinalShardingSQL;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.tablemanager.TableName;

public class CommentShardingSQL
extends ShardingSQL {
    public CommentShardingSQL(StatementInfo stmtInfo) {
        super(stmtInfo);
    }

    @Override
    public ShardingSQL[] sharding(TableInfo shardingSourceTable, ShardingStrategy strategy) {
        SQLCommentStatement sqlCommentStatement = (SQLCommentStatement)this.stmtInfo.getSQLStatement();
        List<String> optTableList = this.getOperateTableList(strategy);
        TableName TableNameOf = TableName.of(strategy.getConfig().getTable());
        ShardingIndexRoute indexRoute = XDBConfig.getShardingConfigProvider().getMainConfig(TableNameOf.getOriginalName()).getOptions().getIndexRoute();
        Set<String> archiveRoutes = indexRoute.getAllArchiveRoutes();
        ArrayList<FinalShardingSQL> retList = new ArrayList<FinalShardingSQL>(3);
        for (String tableName : optTableList) {
            String sql = this.genDDL(tableName, sqlCommentStatement);
            String dbRoute = indexRoute.getRoute(tableName);
            FinalShardingSQL ss = new FinalShardingSQL(new SQLInfo(dbRoute, sql, null, true), tableName);
            retList.add(ss);
            if (!TableName.of(tableName).isPrototypeTable()) continue;
            for (String archiveRoute : archiveRoutes) {
                FinalShardingSQL archiveRouteSl = new FinalShardingSQL(new SQLInfo(archiveRoute, sql, null, true), tableName);
                retList.add(archiveRouteSl);
            }
        }
        return retList.toArray(new ShardingSQL[retList.size()]);
    }

    private List<String> getOperateTableList(ShardingStrategy strategy) {
        ArrayList<String> optTableList = new ArrayList<String>();
        TableName tn = TableName.of(strategy.getConfig().getTable());
        optTableList.add(tn.getPrototypeTable());
        optTableList.add(tn.getOriginalsnapTable());
        String[] tableNames = strategy.getAllShardingTables(false);
        optTableList.addAll(Arrays.asList(tableNames));
        return optTableList;
    }

    private String genDDL(String shardingTable, SQLCommentStatement stmt) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("COMMENT ON ");
        SQLCommentStatement.Type type = stmt.getType();
        SQLExprTableSource on = stmt.getOn();
        if (type == SQLCommentStatement.Type.TABLE) {
            stringBuilder.append("TABLE ");
            stringBuilder.append(SQLUtil.wrapSQLTableName(shardingTable));
        } else {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)on.getExpr();
            String column = propertyExpr.getName();
            stringBuilder.append("COLUMN ");
            stringBuilder.append(SQLUtil.wrapSQLTableName(shardingTable));
            stringBuilder.append(".").append(column);
        }
        stringBuilder.append(" IS ").append(stmt.getComment());
        return stringBuilder.toString();
    }
}

