/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.ddl;

import com.alibaba.druid.sql.ast.SQLIndexDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.ddl.DDLShardingSQL;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.sql.visitor.MySqlPrimaryKeyVisitor;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.WithMapTableStrategy;
import kd.bos.xdb.tablemanager.AliasManager;
import kd.bos.xdb.tablemanager.TableName;

public class CreateTableShardingSQL
extends DDLShardingSQL {
    public CreateTableShardingSQL(StatementInfo stmtInfo) {
        super(stmtInfo);
    }

    @Override
    public final ShardingSQL[] sharding(TableInfo shardingSourceTable, ShardingStrategy strategy) {
        String creatingTable;
        ShardingSQL[] ss = super.sharding(shardingSourceTable, strategy);
        if (strategy instanceof WithMapTableStrategy && TableName.of(creatingTable = ss[0].getShardingTables().get(0)).isPrototypeTable()) {
            ((WithMapTableStrategy)((Object)strategy)).ensureCreateMapTable(strategy);
        }
        return ss;
    }

    @Override
    protected String genDDL(String shardingTable, SQLDDLStatement stmt) {
        SQLCreateTableStatement createStmt = (SQLCreateTableStatement)stmt;
        createStmt.getTableSource().setExpr(SQLUtil.wrapSQLTableName(shardingTable));
        DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        if (dbType == DBType.oracle || dbType == DBType.postgresql) {
            MySqlPrimaryKeyVisitor primaryVisitor = new MySqlPrimaryKeyVisitor();
            createStmt.accept((SQLASTVisitor)((Object)primaryVisitor));
            List<MySqlPrimaryKey> list = primaryVisitor.getList();
            for (MySqlPrimaryKey primary : list) {
                SQLIndexDefinition indexDefinition = primary.getIndexDefinition();
                if (indexDefinition == null || indexDefinition.getName() == null) continue;
                String constraint_name = indexDefinition.getName().getSimpleName();
                String shardingIndexName = AliasManager.get().getIndexAliasName(shardingTable, constraint_name);
                primary.setName(shardingIndexName);
            }
        }
        return createStmt.toString();
    }
}

