/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.ddl;

import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.sharding.config.ShardingIndexRoute;
import kd.bos.xdb.sharding.sql.FinalShardingSQL;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.sql.parser.SQLParser;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.children.ChildrenStrategy;
import kd.bos.xdb.sharding.strategy.map.MapStrategy;
import kd.bos.xdb.tablemanager.TableName;

public abstract class DDLShardingSQL
extends ShardingSQL {
    public DDLShardingSQL(StatementInfo stmtInfo) {
        super(stmtInfo);
    }

    @Override
    public ShardingSQL[] sharding(TableInfo shardingSourceTable, ShardingStrategy strategy) {
        SQLDDLStatement createStmt = this.reParseStatement();
        List<String> optTableList = this.getOperateTableList(strategy);
        TableName TableNameOf = TableName.of(strategy.getConfig().getTable());
        ShardingIndexRoute indexRoute = XDBConfig.getShardingConfigProvider().getMainConfig(TableNameOf.getOriginalName()).getOptions().getIndexRoute();
        Set<String> archiveRoutes = indexRoute.getAllArchiveRoutes();
        ArrayList<FinalShardingSQL> retList = new ArrayList<FinalShardingSQL>(3);
        for (String tableName : optTableList) {
            String sql = this.genDDL(tableName, createStmt);
            String dbRoute = indexRoute.getRoute(tableName);
            FinalShardingSQL ss = new FinalShardingSQL(new SQLInfo(dbRoute, sql, null, true), tableName);
            retList.add(ss);
            if (!TableName.of(tableName).isPrototypeTable()) continue;
            for (String archiveRoute : archiveRoutes) {
                FinalShardingSQL archiveRouteSl = new FinalShardingSQL(new SQLInfo(archiveRoute, sql, null, true), tableName);
                retList.add(archiveRouteSl);
            }
        }
        return retList.toArray(new ShardingSQL[retList.size()]);
    }

    private List<String> getOperateTableList(ShardingStrategy strategy) {
        String[] tableNames;
        ArrayList<String> optTableList = new ArrayList<String>();
        TableName tn = TableName.of(strategy.getConfig().getTable());
        optTableList.add(tn.getPrototypeTable());
        optTableList.add(tn.getOriginalsnapTable());
        if (this.stmtInfo.getStatementType() == StatementType.drop_table) {
            tableNames = strategy.getAllShardingTables(true);
            if (strategy instanceof MapStrategy) {
                optTableList.add(tn.getMapTable());
            }
            if (!(strategy instanceof ChildrenStrategy) && strategy.getConfig().isIndexPK()) {
                optTableList.add(tn.getPKTable());
            }
            XDBConfig.getTableManager().clearCahce(tn.getOriginalName());
        } else {
            tableNames = strategy.getAllShardingTables(false);
        }
        optTableList.addAll(Arrays.asList(tableNames));
        return optTableList;
    }

    protected SQLDDLStatement reParseStatement() {
        StatementInfo shardingStmtInfo = SQLParser.parse(this.stmtInfo.getSQLInfo().isShardingSQL(), this.stmtInfo.getSQLInfo().getSql(), this.stmtInfo.getSQLInfo().getParams());
        return (SQLDDLStatement)shardingStmtInfo.getSQLStatement();
    }

    protected abstract String genDDL(String var1, SQLDDLStatement var2);
}

