/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.dml;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import java.util.List;
import kd.bos.xdb.sharding.sql.FinalShardingSQL;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.condition.ConditionExprList;
import kd.bos.xdb.sharding.sql.condition.ShardingUnreplace;
import kd.bos.xdb.sharding.sql.dml.DMLShardingSQL;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.tablemanager.TableName;

public class DeleteShardingSQL
extends DMLShardingSQL {
    public DeleteShardingSQL(StatementInfo stmtInfo) {
        super(stmtInfo);
    }

    @Override
    protected ConditionExprList collectConditionExprs() {
        ConditionExprList ce = new ConditionExprList();
        SQLDeleteStatement stmt = (SQLDeleteStatement)this.getStatementInfo().getSQLStatement();
        SQLExpr where = stmt.getWhere();
        if (where != null) {
            ce.add(where);
        }
        return ce;
    }

    @Override
    protected boolean isFullShardingValueRequired() {
        return false;
    }

    @Override
    protected ShardingUnreplace replaceWhenGenSQL(SQLStatement stmt, SQLExprTableSource shardingTableExpr) {
        SQLDeleteStatement delStmt = (SQLDeleteStatement)stmt;
        if (delStmt.getFrom() != null) {
            SQLTableSource oldExpr = delStmt.getTableSource();
            if (oldExpr.getAlias() != null) {
                delStmt.setTableSource((SQLExpr)new SQLIdentifierExpr(oldExpr.getAlias()));
            }
            return () -> delStmt.setTableSource(oldExpr);
        }
        return null;
    }

    public ShardingSQL genDeleteShardingIndexPK(TableInfo shardingSourceTable, ShardingStrategy strategy) {
        TableName tn = TableName.of(strategy.getConfig().getTable());
        String pkTable = tn.getPKTable();
        String pkField = ((AbstractShardingStrategy)strategy).getPKField();
        SQLInfo sqlInfo = this.genNoShardingSQL();
        String sql = sqlInfo.getSql();
        int pos = sql.toLowerCase().indexOf(" from ");
        sql = "DELETE FROM " + pkTable + " WHERE FPK IN (SELECT " + pkField + sql.substring(pos) + ")";
        SQLInfo si = new SQLInfo(sqlInfo.getDbRoute(), sql, this.getSQLInfo().getParams(), true);
        return new DeleteIndexPKFinalShardingSQL(si, this.getShardingTables());
    }

    private static final class DeleteIndexPKFinalShardingSQL
    extends FinalShardingSQL {
        public DeleteIndexPKFinalShardingSQL(SQLInfo sqlInfo, List<String> shardingTables) {
            super(sqlInfo, shardingTables);
        }
    }
}

