/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.dml;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.sharding.sql.FinalShardingSQL;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.condition.ConditionExprList;
import kd.bos.xdb.sharding.sql.dml.DMLShardingSQL;
import kd.bos.xdb.sharding.sql.parser.SQLParser;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.children.ChildrenStrategy;
import kd.bos.xdb.tablemanager.TableName;

public class TruncateTableShardingSQL
extends DMLShardingSQL {
    private static final ConditionExprList empty = new ConditionExprList();

    public TruncateTableShardingSQL(StatementInfo stmtInfo) {
        super(stmtInfo);
    }

    @Override
    public ShardingSQL[] sharding(TableInfo shardingSourceTable, ShardingStrategy strategy) {
        SQLStatement truncateStmt = this.reParseStatement();
        List<String> optTableList = this.getOperateTableList(strategy);
        ShardingSQL[] ret = new ShardingSQL[optTableList.size()];
        int i = 0;
        for (String tableName : optTableList) {
            String sql = this.genDML(tableName, truncateStmt);
            String dbRoute = XDBConfig.getShardingConfigProvider().getMainConfig(TableName.of(tableName).getOriginalName()).getOptions().getIndexRoute().getRoute(tableName);
            FinalShardingSQL ss = new FinalShardingSQL(new SQLInfo(dbRoute, sql, null, true), tableName);
            ret[i++] = ss;
        }
        return ret;
    }

    private SQLStatement reParseStatement() {
        StatementInfo shardingStmtInfo = SQLParser.parse(this.stmtInfo.getSQLInfo().isShardingSQL(), this.stmtInfo.getSQLInfo().getSql(), this.stmtInfo.getSQLInfo().getParams());
        return shardingStmtInfo.getSQLStatement();
    }

    private String genDML(String shardingTable, SQLStatement stmt) {
        SQLTruncateStatement truncateStmt = (SQLTruncateStatement)stmt;
        ((SQLExprTableSource)truncateStmt.getTableSources().get(0)).setExpr(SQLUtil.wrapSQLTableName(shardingTable));
        return truncateStmt.toString();
    }

    private List<String> getOperateTableList(ShardingStrategy strategy) {
        ArrayList<String> optTableList = new ArrayList<String>();
        TableName tn = TableName.of(strategy.getConfig().getTable());
        if (!(strategy instanceof ChildrenStrategy) && strategy.getConfig().isIndexPK()) {
            optTableList.add(tn.getPKTable());
        }
        optTableList.addAll(Arrays.asList(strategy.getAllShardingTables(true)));
        XDBConfig.getTableManager().clearCahce(tn.getOriginalName());
        return optTableList;
    }

    @Override
    protected boolean isFullShardingValueRequired() {
        return false;
    }

    @Override
    protected ConditionExprList collectConditionExprs() {
        return empty;
    }
}

