/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.dml;

import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import java.util.ArrayList;
import java.util.List;
import kd.bos.bundle.BosRes;

public class UnoinSelects {
    private SQLUnionQuery unionQuery;
    private List<SelectItem> selects;

    public UnoinSelects(SQLUnionQuery unionQuery) {
        this.unionQuery = unionQuery;
        this.init();
    }

    private void init() {
        this.selects = new ArrayList<SelectItem>();
        this.collectSelects((SQLSelectQuery)this.unionQuery, this.selects, null);
    }

    private void collectSelects(SQLSelectQuery select, List<SelectItem> selects, SQLUnionOperator op) {
        if (select instanceof SQLSelectQueryBlock) {
            selects.add(new SelectItem((SQLSelectQueryBlock)select, op));
        } else if (select instanceof SQLUnionQuery) {
            SQLUnionQuery union = (SQLUnionQuery)select;
            this.collectSelects(union.getLeft(), selects, op);
            this.collectSelects(union.getRight(), selects, union.getOperator());
        } else {
            throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"UnoinSelects_0", (String)"SELECT\u4e0d\u652f\u6301\u67e5\u8be2\u7c7b\u578b:{0}", (Object[])new Object[]{select}));
        }
    }

    public List<SelectItem> getSelects() {
        return this.selects;
    }

    public static class SelectItem {
        private SQLSelectQueryBlock query;
        private SQLUnionOperator op;

        public SelectItem(SQLSelectQueryBlock query, SQLUnionOperator op) {
            this.query = query;
            this.op = op;
        }

        public SQLSelectQueryBlock getQuery() {
            return this.query;
        }

        public SQLUnionOperator getOP() {
            return this.op;
        }
    }
}

