/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.dml.update;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bundle.BosRes;
import kd.bos.exception.XDBErrorCode;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManageContext;
import kd.bos.xdb.context.XDBContext;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.exception.LimitedSQLException;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.sql.PropertyInfo;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.dml.UpdateShardingSQL;
import kd.bos.xdb.sharding.sql.dml.update.ShardingDataMover;
import kd.bos.xdb.sharding.sql.dml.update.UpdateItemRefVisitor;
import kd.bos.xdb.sharding.sql.dml.update.UpdateItemValue;
import kd.bos.xdb.sharding.sql.parser.ConditionInfo;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.sql.visitor.ConditionVisitor;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.ArrayUtil;
import kd.bos.xdb.xpm.config.XpmConfig;
import kd.bos.xdb.xpm.metrics.action.sharding.index.UpdateIndexSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;
import kd.bos.xdb.xpm.metrics.performance.MetricFlagEnum;
import kd.bos.xdb.xpm.metrics.performance.PerformanceMetric;

public final class PrepareUpdate {
    private Object[] updatePatameters;
    private StatementInfo stmtInfo;
    private SQLUpdateStatement stmt;
    private ShardingConfig config;
    private MainTableConfig mainConfig;
    private Map<SQLExpr, PropertyInfo> updateItemPropertyMap;
    private boolean tryPrepareUpdateShardingIndex = false;
    private boolean tryPrepareUpdateShardingField = false;

    public PrepareUpdate(UpdateShardingSQL uss) {
        this.updatePatameters = uss.getSQLInfo().getParams();
        this.stmtInfo = uss.getStatementInfo();
        this.stmt = (SQLUpdateStatement)this.stmtInfo.getSQLStatement();
        String updateTable = this.stmt.getTableName().toString();
        ShardingConfig config = XDBConfig.getShardingConfigProvider().getConfig(updateTable);
        boolean isAllGroupSame = true;
        if (config != null && config.isEnabled() && this.stmtInfo.getTableInfos().size() > 1) {
            String mainTable = this.getMainConfig(config).getTable();
            for (TableInfo tableInfo : this.stmtInfo.getTableInfos()) {
                String temp = tableInfo.toString();
                ShardingConfig tempConfig = XDBConfig.getShardingConfigProvider().getConfig(temp);
                if (tempConfig == null || !tempConfig.isEnabled()) {
                    isAllGroupSame = false;
                } else {
                    String tempMainTable = this.getMainConfig(tempConfig).getTable();
                    if (mainTable.equals(tempMainTable)) continue;
                    isAllGroupSame = false;
                }
                break;
            }
        } else {
            isAllGroupSame = false;
        }
        if (!isAllGroupSame && this.stmtInfo.getTableInfos().size() > 1) {
            for (TableInfo tableInfo : this.stmtInfo.getTableInfos()) {
                ShardingConfig tempConfig;
                String temp = tableInfo.toString();
                if (updateTable.equals(temp) || (tempConfig = XDBConfig.getShardingConfigProvider().getConfig(temp)) == null || !tempConfig.isEnabled()) continue;
                throw new LimitedSQLException(XDBErrorCode.xdbShardingCommon, BosRes.get((String)"bos-xdb", (String)"UpdateShardingFields_2", (String)"\u5206\u7247\u8868\u4e0d\u652f\u6301\u5173\u8054\u8868\u66f4\u65b0:{0} ", (Object[])new Object[]{temp}));
            }
        }
        if (config instanceof MainTableConfig) {
            this.mainConfig = (MainTableConfig)config;
            this.config = this.mainConfig;
            this.updateItemPropertyMap = new HashMap<SQLExpr, PropertyInfo>();
            this.tryPrepareUpdateShardingIndex = true;
            this.tryPrepareUpdateShardingField = true;
        } else {
            ChildrenTableConfig childrenConfig = (ChildrenTableConfig)config;
            if (childrenConfig.isGroupTableConfig() && childrenConfig.getParent() instanceof MainTableConfig) {
                this.mainConfig = (MainTableConfig)childrenConfig.getParent();
                this.config = childrenConfig;
                this.updateItemPropertyMap = new HashMap<SQLExpr, PropertyInfo>();
                this.tryPrepareUpdateShardingIndex = true;
            } else {
                this.mainConfig = null;
                this.config = null;
                this.updateItemPropertyMap = null;
            }
        }
    }

    public void prepare() {
        if (this.tryPrepareUpdateShardingIndex) {
            this.prepareUpdateShardingIndex();
        }
        if (this.tryPrepareUpdateShardingField) {
            this.prepareUpdateShardingField();
        }
    }

    private void prepareUpdateShardingIndex() {
        Set<String> indexSet = this.mainConfig.getOptions().getIndexNameSet();
        if (indexSet.isEmpty()) {
            return;
        }
        String pkField = ((AbstractShardingStrategy)this.mainConfig.getShardingStrategy()).getPKField();
        AtomicInteger pc = new AtomicInteger();
        Map<String, UpdateItemValue> updateIndexFieldValueMap = this.getUpdateFieldValueMap(indexSet, pc, true);
        if (updateIndexFieldValueMap.isEmpty()) {
            return;
        }
        MetricsCollector mc = MetricsCollector.getCurrent();
        mc.sqlFeature().setWithUpdateIndexField(true);
        int parameterFrom = pc.get();
        StringBuilder sql = new StringBuilder(256).append("SELECT ").append(pkField).append(" FROM ").append(this.config.getTable());
        Object[] queryParameters = this.buildWhereAndQueryParameter(sql, parameterFrom);
        String pkTable = TableName.of(this.mainConfig.getTable()).getPKTable();
        StringBuilder updateSQL = new StringBuilder(256).append("UPDATE ").append(pkTable).append(" SET ");
        ArrayList<Object> updateParams = new ArrayList<Object>(updateIndexFieldValueMap.size() + 8);
        int k = 0;
        for (Map.Entry<String, UpdateItemValue> entry : updateIndexFieldValueMap.entrySet()) {
            if (k > 0) {
                updateSQL.append(',');
            }
            UpdateItemValue uv = entry.getValue();
            updateSQL.append(entry.getKey()).append('=').append(uv.getExpr());
            switch (uv.getValueType()) {
                case SINGLE: {
                    updateParams.add(uv.getParam());
                    break;
                }
                case MULTI: {
                    for (Object p : (Object[])uv.getParam()) {
                        updateParams.add(p);
                    }
                    break;
                }
            }
            ++k;
        }
        ArrayList<Object> pkParams = new ArrayList<Object>(8);
        HashSet routes = new HashSet();
        XDBContext ctx = XDB.createContext();
        Object object = null;
        try {
            ctx.addShardingListener(srs -> {
                SQLInfo[] sis;
                ShardingResult sr = srs[0];
                for (SQLInfo si : sis = sr.getSQLInfos()) {
                    if (StringUtils.isNotEmpty((String)si.getDbRoute())) {
                        routes.add(si.getDbRoute());
                        continue;
                    }
                    routes.add(ExtContext.get().getDBRoute());
                }
            });
            try (XDBManageContext xm = XDB.get().withManageContext();
                 ResultSet rs = XDB.get().query(sql.toString(), queryParameters);){
                while (rs.next()) {
                    pkParams.add(rs.getObject(1));
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(e);
            }
        }
        catch (Throwable e) {
            object = e;
            throw e;
        }
        finally {
            if (ctx != null) {
                if (object != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable e) {
                        ((Throwable)object).addSuppressed(e);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        if (routes.size() > 1) {
            StringBuilder msg = new StringBuilder(1024);
            msg.append("Can not write more than one database: ").append(String.join((CharSequence)",", routes));
            throw new LimitedSQLException(XDBErrorCode.xdbMultiDBWrited, msg.toString());
        }
        if (pkParams.size() > 0) {
            try {
                XDBManageContext xm = XDB.get().withManageContext();
                object = null;
                try {
                    xm.setRoute((String)routes.iterator().next());
                    updateSQL.append(" WHERE FPK IN (");
                    ArrayList<Object> doUpdateParams = new ArrayList<Object>(8);
                    StringBuilder doUpdateSQL = new StringBuilder();
                    for (Object[] segpks : ArrayUtil.split(pkParams.toArray(), XDBConfig.get().getUpdateIndexBatchSize())) {
                        int i;
                        doUpdateParams.clear();
                        doUpdateSQL.setLength(0);
                        doUpdateSQL.append((CharSequence)updateSQL);
                        doUpdateParams.addAll(updateParams);
                        int m = segpks.length;
                        for (i = 0; i < m; ++i) {
                            if (i > 0) {
                                doUpdateSQL.append(',');
                            }
                            doUpdateSQL.append('?');
                            doUpdateParams.add(segpks[i]);
                        }
                        doUpdateSQL.append(") AND (");
                        i = 0;
                        for (Map.Entry<String, UpdateItemValue> entry : updateIndexFieldValueMap.entrySet()) {
                            if (i > 0) {
                                doUpdateSQL.append(" OR ");
                            }
                            UpdateItemValue uv = entry.getValue();
                            doUpdateSQL.append(entry.getKey()).append("!=").append(uv.getExpr());
                            switch (uv.getValueType()) {
                                case SINGLE: {
                                    doUpdateParams.add(uv.getParam());
                                    if (!uv.isOnlyVarRef()) break;
                                    doUpdateSQL.append(" OR ").append(entry.getKey()).append(" IS NULL");
                                    break;
                                }
                                case MULTI: {
                                    for (Object p : (Object[])uv.getParam()) {
                                        doUpdateParams.add(p);
                                    }
                                    break;
                                }
                            }
                            ++i;
                        }
                        doUpdateSQL.append(')');
                        if (mc.isActionMetricEnabled()) {
                            mc.actionMetric().stat(new UpdateIndexSpan(pkTable, doUpdateSQL.toString(), doUpdateParams));
                        }
                        mc.sqlFeature().setDoUpdateIndexField(true);
                        XDB.get().update(NoShardingHint.genNoShardingSQL(doUpdateSQL.toString()), doUpdateParams.toArray());
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (xm != null) {
                        if (object != null) {
                            try {
                                xm.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            xm.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(e);
            }
        }
    }

    private void prepareUpdateShardingField() {
        String[] fields = this.config.getShardingFields();
        HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(fields));
        List items = this.stmt.getItems();
        HashSet<SQLUpdateSetItem> updateShardingFieldSet = new HashSet<SQLUpdateSetItem>();
        for (SQLUpdateSetItem updateItem : items) {
            PropertyInfo pi = this.parsePropertyInfo(updateItem.getColumn());
            if (!fieldSet.contains(pi.getField())) continue;
            updateShardingFieldSet.add(updateItem);
        }
        if (updateShardingFieldSet.isEmpty()) {
            return;
        }
        MetricsCollector mc = MetricsCollector.getCurrent();
        mc.sqlFeature().setWithUpdateShardingField(true);
        if (mc.isPerformanceMetricEnabled()) {
            PerformanceMetric pm = mc.performanceMetric();
            pm.setUpdateShardingField(true);
            if (XpmConfig.isAlarmupdateShardingField()) {
                TreeSet<String> udpateFields = new TreeSet<String>();
                for (SQLUpdateSetItem updateItem : updateShardingFieldSet) {
                    udpateFields.add(this.parsePropertyInfo(updateItem.getColumn()).getField());
                }
                pm.logCallStack("Update sharding field: " + udpateFields + "\n\tSQL:\n\t" + this.stmtInfo.toString().replaceAll("\n", "\n\t"));
                pm.setMetricFlag(MetricFlagEnum.updateSharingField);
            }
        }
        String pkField = ((AbstractShardingStrategy)this.config.getShardingStrategy()).getPKField();
        AtomicInteger pc = new AtomicInteger();
        Map<String, UpdateItemValue> updateShardingFieldValueMap = this.getUpdateFieldValueMap(fieldSet, pc, false);
        int parameterFrom = pc.get();
        StringBuilder sql = new StringBuilder(256).append("SELECT ");
        int k = 0;
        for (String field : fields) {
            if (k > 0) {
                sql.append(',');
            }
            sql.append(field);
            ++k;
        }
        boolean shardingFieldWithPK = fieldSet.contains(pkField);
        int shardingFieldIndex = -1;
        if (shardingFieldWithPK) {
            for (int i = 0; i < fields.length; ++i) {
                if (!pkField.equals(fields[i])) continue;
                shardingFieldIndex = i;
                break;
            }
        } else {
            sql.append(',').append(pkField);
            shardingFieldIndex = fields.length;
        }
        sql.append(" FROM ").append(this.stmt.getTableName());
        Object[] queryParameters = this.buildWhereAndQueryParameter(sql, parameterFrom);
        ShardingDataMover mover = new ShardingDataMover((MainTableConfig)this.config);
        int N = fields.length;
        try (XDBManageContext xm = XDB.get().withManageContext();
             ResultSet rs = XDB.get().query(sql.toString(), queryParameters);){
            Object[] oldValues = new Object[N];
            Object[] newValues = new Object[N];
            boolean hasMoveData = false;
            boolean doUpdate = false;
            while (rs.next()) {
                if (!doUpdate) {
                    mc.sqlFeature().setDoUpdateShardingField(true);
                    doUpdate = true;
                }
                for (int i = 0; i < N; ++i) {
                    oldValues[i] = rs.getObject(i + 1);
                    newValues[i] = updateShardingFieldValueMap.containsKey(fields[i]) ? updateShardingFieldValueMap.get(fields[i]).getParam() : oldValues[i];
                }
                Object pk = shardingFieldWithPK ? newValues[shardingFieldIndex] : rs.getObject(N + 1);
                if (!mover.moveRow(pk, oldValues, newValues) || hasMoveData) continue;
                mc.sqlFeature().setDoUpdateShardingFieldMoveData(true);
                hasMoveData = true;
            }
            if (hasMoveData) {
                mover.onShardingDataMoved();
            }
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    private PropertyInfo parsePropertyInfo(SQLExpr updateItemExpr) {
        return this.updateItemPropertyMap.computeIfAbsent(updateItemExpr, k -> PropertyInfo.of(k, true));
    }

    private Map<String, UpdateItemValue> getUpdateFieldValueMap(Set<String> fieldSet, AtomicInteger parameterFrom, boolean allowExpress) {
        HashMap<String, UpdateItemValue> updateValueMap = new HashMap<String, UpdateItemValue>(2);
        UpdateItemRefVisitor visitor = new UpdateItemRefVisitor(this.updatePatameters);
        for (SQLUpdateSetItem selectItem : this.stmt.getItems()) {
            PropertyInfo pp = this.parsePropertyInfo(selectItem.getColumn());
            UpdateItemValue uv = visitor.visitUpdateItemValue(selectItem.getValue());
            int varRefCount = uv.getVarRefCount();
            if (varRefCount > 0) {
                parameterFrom.set(parameterFrom.get() + varRefCount);
            }
            if (!fieldSet.contains(pp.getField())) continue;
            if (!allowExpress && selectItem.getValue() instanceof SQLBinaryOpExpr) {
                throw new LimitedSQLException(XDBErrorCode.xdbShardingCommon, BosRes.get((String)"bos-xdb", (String)"UpdateShardingFields_1", (String)"\u66f4\u65b0\u5206\u7247\u5c5e\u6027\u4e0d\u652f\u6301\u8868\u8fbe\u5f0f{0}:{1}\u3002 ", (Object[])new Object[]{selectItem.getColumn(), selectItem}));
            }
            updateValueMap.put(pp.getField(), uv);
        }
        return updateValueMap;
    }

    private Object[] buildWhereAndQueryParameter(StringBuilder sql, int parameterFrom) {
        if (this.stmt.getWhere() == null) {
            return null;
        }
        SQLExpr where = this.stmt.getWhere().clone();
        ConditionVisitor cv = new ConditionVisitor();
        where.accept((SQLASTVisitor)cv);
        ArrayList<Object> queryParameters = new ArrayList<Object>(this.updatePatameters.length - parameterFrom);
        for (int i = parameterFrom; i < this.updatePatameters.length; ++i) {
            queryParameters.add(this.updatePatameters[i]);
        }
        for (ConditionInfo condition : cv.getConditionInfos()) {
            SQLExpr conditionExp = condition.getSQLExpr();
            SQLUtil.expandInOrLike(conditionExp, this.updatePatameters[parameterFrom + condition.getPosIndex()]);
        }
        StringBuilder wsql = new StringBuilder(64);
        SQLASTOutputVisitor visitor = new SQLASTOutputVisitor(wsql);
        where.accept((SQLASTVisitor)visitor);
        sql.append(" WHERE ").append(wsql.toString());
        ArrayList<Object> ret = new ArrayList<Object>(queryParameters.size());
        for (Object e : queryParameters) {
            if (e != null && e.getClass().isArray()) {
                int n = Array.getLength(e);
                for (int i = 0; i < n; ++i) {
                    ret.add(Array.get(e, i));
                }
                continue;
            }
            ret.add(e);
        }
        return ret.toArray();
    }

    private MainTableConfig getMainConfig(ShardingConfig config) {
        if (config instanceof MainTableConfig) {
            return (MainTableConfig)config;
        }
        return this.getMainConfig(((ChildrenTableConfig)config).getParent());
    }
}

