/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.parser;

import com.alibaba.druid.sql.ast.KSQLTop;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlExportParameterVisitor;
import com.alibaba.druid.sql.visitor.ExportParameterVisitorUtils;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.VisitorFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.parser.ExtractParameterPosition;
import kd.bos.xdb.sharding.sql.parser.SQLAppendable;

class SQLParameterVisitor
extends MySqlExportParameterVisitor {
    private final boolean merge;
    protected ExtractParameterPosition ep;
    protected final Object[] originalParams;
    protected int originalParamsIndex = 0;
    protected SQLInfo sqlInfo = null;
    protected SQLAppendable myAppender;

    protected SQLParameterVisitor(Object[] originalParams, boolean merge) {
        super(new ArrayList(originalParams == null ? 0 : originalParams.length), (Appendable)new SQLAppendable(), true);
        this.merge = merge;
        this.myAppender = (SQLAppendable)this.appender;
        this.config(VisitorFeature.OutputParameterizedQuesUnMergeOr, !merge);
        this.config(VisitorFeature.OutputParameterizedQuesUnMergeInList, !merge);
        this.setParameterizedMergeInList(false);
        this.setShardingSupport(false);
        this.originalParams = originalParams == null ? new Object[]{} : originalParams;
    }

    public SQLInfo getSQLInfo() {
        if (this.sqlInfo == null) {
            this.sqlInfo = new SQLInfo(this.myAppender.getSQL(), this.getParameters().toArray(), false);
        }
        return this.sqlInfo;
    }

    public boolean visit(SQLVariantRefExpr x) {
        String varName = x.getName();
        if (varName.length() == 1 && varName.charAt(0) == '?') {
            SQLBinaryOpExpr be;
            int mergedSize = x.getParent() instanceof SQLBinaryOpExpr ? ((be = (SQLBinaryOpExpr)x.getParent()).getMergedList() == null ? 1 : this.countMergedSize(be) + 1) : 1;
            if (mergedSize == 1) {
                this.parameters.add(this.originalParams[this.originalParamsIndex++]);
            } else {
                this.parameters.add(Arrays.copyOfRange(this.originalParams, this.originalParamsIndex, this.originalParamsIndex + mergedSize));
                this.originalParamsIndex += mergedSize;
            }
        }
        return super.visit(x);
    }

    private int countMergedSize(SQLBinaryOpExpr be) {
        int c = 0;
        List<SQLObject> mergedList = be.getMergedList();
        if (mergedList != null) {
            ++c;
            for (SQLObject sub : mergedList) {
                c += this.countMergedSize((SQLBinaryOpExpr)sub);
            }
        }
        return c;
    }

    public boolean visit(SQLInListExpr x) {
        if (this.parameterized) {
            if (this.merge) {
                ArrayList<Object> subList = new ArrayList<Object>();
                int i = 0;
                boolean changed = false;
                int fromIndex = this.parameters.size();
                for (SQLExpr target : new ArrayList(x.getTargetList())) {
                    if (target instanceof SQLVariantRefExpr) {
                        this.parameters.add(this.originalParams[this.originalParamsIndex++]);
                    } else {
                        ExportParameterVisitorUtils.exportParameter(subList, target);
                        subList.clear();
                        x.getTargetList().remove(i);
                        SQLVariantRefExpr ref = new SQLVariantRefExpr("?");
                        ref.setParent((SQLObject)x);
                        x.getTargetList().add(i, ref);
                        if (!changed) {
                            changed = true;
                        }
                    }
                    ++i;
                }
                if (changed) {
                    i = 0;
                    for (SQLExpr target : x.getTargetList()) {
                        ((SQLVariantRefExpr)target).setIndex(i++);
                    }
                }
                List inParameterList = this.parameters.subList(fromIndex, this.parameters.size());
                Object[] inParameters = inParameterList.toArray();
                int n = inParameterList.size();
                for (int j = 0; j < n; ++j) {
                    this.parameters.remove(fromIndex);
                }
                this.parameters.add(inParameters);
            } else {
                return this.super_super_visit(x);
            }
        }
        return super.visit(x);
    }

    private boolean super_super_visit(SQLInListExpr x) {
        if (this.parameterized) {
            List targetList = x.getTargetList();
            boolean allLiteral = true;
            for (SQLExpr item : targetList) {
                if (item instanceof SQLLiteralExpr) continue;
                if (item instanceof SQLListExpr) {
                    SQLListExpr list = (SQLListExpr)item;
                    for (SQLExpr listItem : list.getItems()) {
                        if (listItem instanceof SQLLiteralExpr) continue;
                        allLiteral = false;
                        break;
                    }
                    if (!allLiteral) continue;
                    break;
                }
                allLiteral = false;
                break;
            }
            if (allLiteral) {
                boolean changed = true;
                if (targetList.size() == 1 && targetList.get(0) instanceof SQLVariantRefExpr) {
                    changed = false;
                }
                this.printExpr(x.getExpr());
                if (x.isNot()) {
                    this.print(this.ucase ? " NOT IN" : " not in");
                } else {
                    this.print(this.ucase ? " IN" : " in");
                }
                if (!this.isParameterizedQuesUnMergeInList() || targetList.size() == 1) {
                    this.print(" (?)");
                } else {
                    this.print(" (");
                    for (int i = 0; i < targetList.size(); ++i) {
                        if (i != 0) {
                            this.print(",");
                        }
                        this.print(" ?");
                    }
                    this.print(")");
                }
                if (changed) {
                    this.incrementReplaceCunt();
                    if (this.parameters != null) {
                        if (this.parameterizedMergeInList) {
                            ArrayList subList = new ArrayList(x.getTargetList().size());
                            for (SQLExpr target : x.getTargetList()) {
                                ExportParameterVisitorUtils.exportParameter((List<Object>)subList, target);
                            }
                            if (subList != null) {
                                this.parameters.add(subList);
                            }
                        } else {
                            for (SQLExpr target : x.getTargetList()) {
                                ExportParameterVisitorUtils.exportParameter((List<Object>)this.parameters, target);
                            }
                        }
                    }
                }
                return false;
            }
        }
        this.printExpr(x.getExpr());
        if (x.isNot()) {
            this.print0(this.ucase ? " NOT IN (" : " not in (");
        } else {
            this.print0(this.ucase ? " IN (" : " in (");
        }
        List list = x.getTargetList();
        boolean printLn = false;
        if (list.size() > 5) {
            printLn = true;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                if (list.get(i) instanceof SQLCharExpr) continue;
                printLn = false;
                break;
            }
        }
        if (printLn) {
            ++this.indentCount;
            this.println();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.print0(", ");
                    this.println();
                }
                SQLExpr item = (SQLExpr)list.get(i);
                this.printExpr(item);
            }
            --this.indentCount;
            this.println();
        } else {
            List targetList = x.getTargetList();
            for (int i = 0; i < targetList.size(); ++i) {
                if (i != 0) {
                    this.print0(", ");
                }
                this.printExpr((SQLExpr)targetList.get(i));
            }
        }
        this.print(')');
        return false;
    }

    public boolean visit(SQLInsertStatement.ValuesClause x) {
        SQLInsertStatement stmt = (SQLInsertStatement)x.getParent();
        for (SQLObject obj : stmt.getChildren()) {
            if (!(obj instanceof SQLInsertStatement.ValuesClause) || obj == x) continue;
            throw ExceptionUtil.wrap(BosRes.get((String)"bos-xdb", (String)"SQLExtractParameterVisitor_0", (String)"\u4e0d\u652f\u6301\u4e00\u6761Insert\u8bed\u53e5\u63d2\u5165\u591a\u884c\u6570\u636e:{0} ", (Object[])new Object[]{stmt}));
        }
        return super.visit(x);
    }

    public boolean visit(KSQLTop x) {
        this.print0(this.ucase ? "TOP " : "top ");
        boolean old = this.parameterized;
        this.parameterized = false;
        SQLExpr rowCount = x.getRowCount();
        this.printExpr(rowCount);
        SQLExpr offset = x.getOffset();
        if (offset != null) {
            this.print0(", ");
            this.printExpr(offset);
        }
        this.parameterized = old;
        return false;
    }

    public boolean visit(SQLLimit x) {
        this.print0(this.ucase ? "LIMIT " : "limit ");
        SQLExpr offset = x.getOffset();
        boolean old = this.parameterized;
        this.parameterized = false;
        if (offset != null) {
            this.printExpr(offset);
            this.print0(", ");
        }
        SQLExpr rowCount = x.getRowCount();
        this.printExpr(rowCount);
        this.parameterized = old;
        return false;
    }

    public boolean visit(SQLCaseExpr x) {
        boolean old = this.parameterized;
        this.parameterized = false;
        ++this.indentCount;
        this.print0(this.ucase ? "CASE " : "case ");
        SQLExpr valueExpr = x.getValueExpr();
        if (valueExpr != null) {
            this.printExpr(valueExpr);
        }
        List items = x.getItems();
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            this.println();
            this.visit((SQLCaseExpr.Item)items.get(i));
        }
        SQLExpr elExpr = x.getElseExpr();
        if (elExpr != null) {
            this.println();
            this.print0(this.ucase ? "ELSE " : "else ");
            if (elExpr instanceof SQLCaseExpr) {
                ++this.indentCount;
                this.println();
                this.visit((SQLCaseExpr)elExpr);
                --this.indentCount;
            } else {
                this.printExpr(elExpr);
            }
        }
        --this.indentCount;
        this.println();
        this.print0(this.ucase ? "END" : "end");
        this.parameterized = old;
        return false;
    }

    public boolean visit(SQLSelectItem x) {
        SQLExpr expr;
        boolean old = this.parameterized;
        this.parameterized = false;
        if (x.isConnectByRoot()) {
            this.print0(this.ucase ? "CONNECT_BY_ROOT " : "connect_by_root ");
        }
        if ((expr = x.getExpr()) instanceof SQLIdentifierExpr) {
            this.print0(((SQLIdentifierExpr)expr).getName());
        } else if (expr instanceof SQLPropertyExpr) {
            this.visit((SQLPropertyExpr)expr);
        } else {
            this.printExpr(expr);
        }
        String alias = x.getAlias();
        if (alias != null && alias.length() > 0) {
            this.print0(this.ucase ? " AS " : " as ");
            char c0 = alias.charAt(0);
            if (alias.indexOf(32) != -1 && c0 != '\"' && c0 != '\'') {
                this.print('\"');
                this.print0(alias);
                this.print('\"');
            } else {
                this.print0(alias);
            }
        }
        this.parameterized = old;
        return false;
    }

    public boolean visit(SQLAlterTableAddColumn x) {
        this.print0(this.ucase ? "ADD " : "add ");
        if (x.getColumns().size() > 1) {
            this.print('(');
        }
        this.printAndAccept(x.getColumns(), ", ");
        if (x.getFirstColumn() != null) {
            this.print0(this.ucase ? " FIRST " : " first ");
            x.getFirstColumn().accept((SQLASTVisitor)((Object)this));
        } else if (x.getAfterColumn() != null) {
            this.print0(this.ucase ? " AFTER " : " after ");
            x.getAfterColumn().accept((SQLASTVisitor)((Object)this));
        } else if (x.isFirst()) {
            this.print0(this.ucase ? " FIRST" : " first");
        }
        if (x.getColumns().size() > 1) {
            this.print(')');
        }
        return false;
    }

    public boolean visit(SQLCommentStatement x) {
        SQLCommentStatement.Type type = x.getType();
        SQLExprTableSource on = x.getOn();
        if (type == SQLCommentStatement.Type.TABLE) {
            this.print0(this.ucase ? "COMMENT ON TABLE " : "comment on table ");
            on.accept((SQLASTVisitor)((Object)this));
            this.print0(this.ucase ? " IS " : " is ");
            this.print0(x.getComment().toString());
        } else {
            this.print0(this.ucase ? "COMMENT ON COLUMN " : "comment on column ");
            on.accept((SQLASTVisitor)((Object)this));
            this.print0(this.ucase ? " IS " : " is ");
            this.print0(x.getComment().toString());
        }
        return false;
    }

    public void incrementReplaceCunt() {
        if (this.ep != null) {
            this.ep.add(this.parameters.size());
        }
        super.incrementReplaceCunt();
    }

    public boolean isExtractNewParameter() {
        return this.replaceCount > 0;
    }

    public int getExtractNewParameterCount() {
        return this.replaceCount;
    }
}

