/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.util.DevTag;

public class SQLUtil {
    public static String wrapSQLTableName(String tableName) {
        DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        switch (dbType) {
            case mysql: 
            case tdsql: 
            case tidb: {
                if (tableName.charAt(0) == '`') break;
                return "`" + tableName + "`";
            }
        }
        return tableName;
    }

    public static String unWrapSQLTableName(String tableName) {
        char ch = tableName.charAt(0);
        if (ch == '\'' || ch == '\"' || ch == '`') {
            if (tableName.charAt(tableName.length() - 1) == ch) {
                return tableName.substring(1, tableName.length() - 1);
            }
            throw new IllegalArgumentException(BosRes.get((String)"bos-xdb", (String)"SQLUtil_0", (String)"\u8868\u540d\u4e0d\u89c4\u8303:{0}", (Object[])new Object[]{tableName}));
        }
        return tableName;
    }

    public static String toSQLString(String sql, Object[] params) {
        if (params == null || params.length == 0) {
            return sql;
        }
        ArrayList<Object> parameters = new ArrayList<Object>(params.length + 2);
        for (Object obj : params) {
            if (obj == null) {
                parameters.add(null);
                continue;
            }
            if (obj.getClass().isArray()) {
                int n = Array.getLength(obj);
                for (int j = 0; j < n; ++j) {
                    parameters.add(Array.get(obj, j));
                }
                continue;
            }
            if (obj instanceof Iterable) {
                Iterator iter = ((Iterable)obj).iterator();
                while (iter.hasNext()) {
                    parameters.add(iter.next());
                }
                continue;
            }
            parameters.add(obj);
        }
        String dbType = "mysql";
        List statementList = SQLUtils.parseStatements((String)sql, (String)dbType);
        String sqlWithParameter = SQLUtils.toSQLString((List)statementList, (DbType)DbType.valueOf((String)dbType), parameters);
        return sqlWithParameter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<SQLExprTableSource> prepareOwnerList(SQLObject expr) {
        ArrayList<SQLExprTableSource> prepareOwnerList = new ArrayList<SQLExprTableSource>();
        SQLObject selectQuery = expr.getParent();
        while (!(selectQuery instanceof SQLSelectQuery)) {
            selectQuery = selectQuery.getParent();
        }
        if (!(selectQuery instanceof SQLSelectQueryBlock)) return prepareOwnerList;
        SQLSelectQueryBlock sqb = (SQLSelectQueryBlock)selectQuery;
        SQLTableSource from = sqb.getFrom();
        if (from instanceof SQLExprTableSource) {
            prepareOwnerList.add((SQLExprTableSource)from);
            return prepareOwnerList;
        } else if (from instanceof SQLJoinTableSource) {
            SQLJoinTableSource js = (SQLJoinTableSource)from;
            SQLTableSource jsLeft = js.getLeft();
            SQLTableSource jsRight = js.getRight();
            if (!(jsLeft instanceof SQLExprTableSource)) {
                throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"SQLUtil_1", (String)"\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u5757:{0}", (Object[])new Object[]{jsLeft.getClass()}));
            }
            prepareOwnerList.add((SQLExprTableSource)jsLeft);
            if (!(jsRight instanceof SQLExprTableSource)) throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"SQLUtil_1", (String)"\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u5757:{0}", (Object[])new Object[]{jsRight.getClass()}));
            prepareOwnerList.add((SQLExprTableSource)jsRight);
            return prepareOwnerList;
        } else {
            if (from instanceof SQLUnionQueryTableSource) return prepareOwnerList;
            throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"SQLUtil_1", (String)"\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u5757:{0}", (Object[])new Object[]{from.getClass()}));
        }
    }

    public static Object expandInOrLike(SQLExpr exp, Object param) {
        List inList;
        DevTag.expandArrayParameters();
        Object value = param;
        int parameterCount = 1;
        if (param != null) {
            boolean processed = false;
            if (param instanceof List) {
                List vs = (List)param;
                if (vs.isEmpty()) {
                    value = null;
                    processed = true;
                } else if (vs.size() == 1) {
                    value = vs.get(0);
                    processed = true;
                }
            }
            if (!processed) {
                if (param.getClass().isArray()) {
                    parameterCount = Array.getLength(param);
                } else if (param instanceof Collection) {
                    parameterCount = ((Collection)param).size();
                } else if (param instanceof Iterable) {
                    int j = 0;
                    Iterator iter = ((Iterable)param).iterator();
                    while (iter.hasNext()) {
                        iter.next();
                        ++j;
                    }
                    parameterCount = j;
                }
                value = param;
            }
        }
        if (parameterCount > 1 && exp instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)exp).getOperator() == SQLBinaryOperator.Like) {
            SQLBinaryOpExpr likeExpr = null;
            for (int j = 0; j < parameterCount; ++j) {
                SQLVariantRefExpr ref = new SQLVariantRefExpr("?");
                ref.setIndex(j);
                SQLBinaryOpExpr be = new SQLBinaryOpExpr(((SQLBinaryOpExpr)exp).getLeft().clone(), SQLBinaryOperator.Like, (SQLExpr)ref);
                likeExpr = likeExpr == null ? be : new SQLBinaryOpExpr((SQLExpr)likeExpr, SQLBinaryOperator.BooleanOr, (SQLExpr)be);
            }
            SQLReplaceable parent = (SQLReplaceable)exp.getParent();
            parent.replace(exp, likeExpr);
            exp = likeExpr;
        } else if (parameterCount > 1 && !(exp instanceof SQLInListExpr)) {
            SQLInListExpr inExpr = new SQLInListExpr(((SQLBinaryOpExpr)exp).getLeft());
            inList = inExpr.getTargetList();
            for (int j = 0; j < parameterCount; ++j) {
                SQLVariantRefExpr ref = new SQLVariantRefExpr("?");
                ref.setParent((SQLObject)exp);
                ref.setIndex(j);
                inList.add(ref);
            }
            SQLReplaceable parent = (SQLReplaceable)exp.getParent();
            parent.replace(exp, (SQLExpr)inExpr);
            exp = inExpr;
        } else if (exp instanceof SQLInListExpr) {
            SQLInListExpr inExpr = (SQLInListExpr)exp;
            inList = inExpr.getTargetList();
            if (inList.size() != parameterCount) {
                inList.clear();
                for (int j = 0; j < parameterCount; ++j) {
                    SQLVariantRefExpr ref = new SQLVariantRefExpr("?");
                    ref.setParent((SQLObject)exp);
                    ref.setIndex(j);
                    inList.add(ref);
                }
            }
        } else if (!(exp instanceof SQLBinaryOpExpr || exp instanceof SQLBetweenExpr || exp instanceof SQLMethodInvokeExpr && ("UDT_VARCHAR(?)".equals(exp.toString().toUpperCase()) || "UDT_INTTABLE(?)".equals(exp.toString().toUpperCase()) || "UDT_VARCHARTABLE(?)".equals(exp.toString().toUpperCase())))) {
            throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"ConditionShardingSQL_1", (String)"\u5728\u8fd9\u589e\u52a0\u5bf9SQL ?\u7684\u4fee\u6539:{0} \u3002", (Object[])new Object[]{exp.getClass()}));
        }
        return value;
    }
}

