/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.bundle.BosRes;
import kd.bos.exception.XDBErrorCode;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.engine.ShardingContext;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.exception.LimitedSQLException;
import kd.bos.xdb.exception.SQLShardingException;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.ShardingFieldValue;
import kd.bos.xdb.sharding.ShardingGroupTable;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.indexpk.IndexPKStore;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.ParamsGroup;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.sql.condition.AlwaysValue;
import kd.bos.xdb.sharding.sql.dml.update.ShardingDataMoveMeta;
import kd.bos.xdb.sharding.strategy.MixShardingGroupTables;
import kd.bos.xdb.sharding.strategy.ShardingFieldsCache;
import kd.bos.xdb.sharding.strategy.ShardingParamsCombiner;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.SupportBetweenAndSharding;
import kd.bos.xdb.sharding.strategy.WithMapTableStrategy;
import kd.bos.xdb.sharding.strategy.children.ChildrenStrategy;
import kd.bos.xdb.sharding.strategy.spare.IndexPKSpareStrategy;
import kd.bos.xdb.sharding.strategy.spare.IndexSpareStrategy;
import kd.bos.xdb.sharding.strategy.spare.SpareStrategy;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.ArrayUtil;
import kd.bos.xdb.util.Pair;
import kd.bos.xdb.xpm.metrics.action.sharding.MixShardingSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.ShardingAllSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.ShardingParameterSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;
import kd.bos.xdb.xpm.metrics.performance.PerformanceMetric;

public abstract class AbstractShardingStrategy
implements ShardingStrategy,
SupportBetweenAndSharding,
XDBLogable {
    private static final FilterType[] between_and_filter_lt = new FilterType[]{FilterType.lt};
    private static final FilterType[] between_and_filter_gt = new FilterType[]{FilterType.gt};
    private static final FilterType[] between_and_filter_ge = new FilterType[]{FilterType.ge};
    private static final FilterType[] between_and_filter_le = new FilterType[]{FilterType.le};
    private static final Pair<Boolean, Supplier<ShardingGroupTable[]>> empty_spare_ret_value = new Pair<Boolean, Supplier<ShardingGroupTable[]>>(false, () -> null);
    protected final ShardingFieldsCache shardingIndexEqCache = new ShardingFieldsCache(this);
    private final Object spareStrategiesLock = new Object();
    private String pkField = "fid";
    private boolean indexPK;
    private boolean IDSequence;
    protected IndexPKStore indexPKStore;
    private List<SpareStrategy> spareStrategies;
    protected ShardingConfig config;
    protected TableName tableName;
    protected boolean singleShardingField;
    protected boolean ensureTableInited = false;

    @Override
    public final ShardingConfig getConfig() {
        return this.config;
    }

    @Override
    public final void initConfig(ShardingConfig config) {
        this.config = config;
        String[] configFields = config.getShardingFields();
        if (configFields == null || configFields.length == 0) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-xdb", (String)"AbstractShardingStrategy_0", (String)"{0}\u5206\u7247\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a.", (Object[])new Object[]{config.getTable()}));
        }
        this.tableName = TableName.of(config.getTable());
        boolean bl = this.singleShardingField = config.getShardingFields().length == 1;
        if (this.shardingIndexEqCache.getName() == null) {
            this.shardingIndexEqCache.setName(config.getTable() + '#' + this.getClass().getSimpleName());
        }
        config.setIndexPK(this.indexPK);
        this.initConfigAssignIndexPKStore();
        this.onInitConfig();
    }

    protected void initConfigAssignIndexPKStore() {
        this.indexPKStore = new IndexPKStore(this.config.getName());
        this.indexPKStore.initCacheSize(this.config.getTable());
    }

    @Override
    public void ensureTableInited() {
        if (!this.ensureTableInited) {
            TableManager tm = XDBConfig.getTableManager();
            tm.clearCahce(this.config.getTable());
            String prototypeTable = this.tableName.getPrototypeTable();
            try {
                if (!XDB.get().existTable(prototypeTable)) {
                    tm.createPrototypeTable(prototypeTable);
                }
                if (WithMapTableStrategy.class.isAssignableFrom(this.getClass())) {
                    ((WithMapTableStrategy)((Object)this)).ensureCreateMapTable(this);
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(BosRes.get((String)"bos-xdb", (String)"AbstractShardingStrategy_1", (String)"\u539f\u578b\u8868\u521b\u5efa\u9519\u8bef:{0}", (Object[])new Object[]{e.getMessage()}), e);
            }
            this.ensureTableInited = true;
        }
    }

    @Override
    public boolean notValueExcludeSharding() {
        return false;
    }

    @Override
    public long[] shardingIndexBetweenAnd(Object v1, Object v2, boolean not) {
        if (not) {
            long[] froms = this.shardingIndex(between_and_filter_lt, new Object[]{v1});
            long[] tos = this.shardingIndex(between_and_filter_gt, new Object[]{v2});
            if (froms.length == 0 || tos.length == 0) {
                return ArrayUtil.EMPTY_INDEXIES;
            }
            long[] indexies = new long[froms.length + tos.length];
            int i = 0;
            for (long index : froms) {
                indexies[i++] = index;
            }
            for (long index : tos) {
                indexies[i++] = index;
            }
            return indexies;
        }
        long[] froms = this.shardingIndex(between_and_filter_ge, new Object[]{v1});
        long[] tos = this.shardingIndex(between_and_filter_le, new Object[]{v2});
        if (froms.length == 0 || tos.length == 0) {
            return ArrayUtil.EMPTY_INDEXIES;
        }
        HashSet<Long> set = new HashSet<Long>(froms.length);
        for (long index : froms) {
            set.add(index);
        }
        ArrayList<Long> list = new ArrayList<Long>(Math.max(froms.length, tos.length));
        for (long index : tos) {
            if (!set.contains(index)) continue;
            list.add(index);
        }
        if (list.isEmpty()) {
            return ArrayUtil.EMPTY_INDEXIES;
        }
        long[] indexies = new long[list.size()];
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            long index;
            index = (Long)iterator.next();
            indexies[i++] = index;
        }
        return indexies;
    }

    @Override
    public final String[] getAllShardingTablesUseHintContext(boolean onlyExists) {
        ShardingContext ctx = ShardingContext.get();
        String[] hintShardingTables = ctx.getHintShardingTables(this);
        while (hintShardingTables == null && (ctx = ctx.getParent()) != null) {
            hintShardingTables = ctx.getHintShardingTables(this);
        }
        if (hintShardingTables != null) {
            if (!this.tableName.getOriginalName().equals(TableName.of(hintShardingTables[0]).getOriginalName())) {
                String[] buf = new String[hintShardingTables.length];
                for (int i = 0; i < hintShardingTables.length; ++i) {
                    buf[i] = this.tableName.getShardingTable(TableName.of(hintShardingTables[i]).getSuffix());
                }
                hintShardingTables = buf;
            }
            return hintShardingTables;
        }
        return this.getAllShardingTables(onlyExists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final ShardingGroupTable[] shardingGroups(ParamsGroup pg, boolean fullShardingValueRequired) {
        try {
            Pair<Boolean, Supplier<ShardingGroupTable[]>> pair;
            ShardingGroupTable[] ret = null;
            MetricsCollector mc = MetricsCollector.getCurrent();
            AlwaysValue oldValue = pg.getAlwaysValue();
            Supplier<String[]> lazyTableCache = () -> this.getAllShardingTablesUseHintContext(true);
            if (XDBConfig.get().isMixSharding()) {
                MixShardingGroupTables mix = new MixShardingGroupTables(this, () -> {
                    pg.setAlwaysValue(oldValue);
                    return this.doShardingGroups(pg, lazyTableCache, fullShardingValueRequired, false, mc);
                }, () -> {
                    ArrayList<Pair<MixShardingGroupTables.ShardingGroupsInovker, ShardingStrategy>> sps = new ArrayList<Pair<MixShardingGroupTables.ShardingGroupsInovker, ShardingStrategy>>(8);
                    for (ShardingStrategy shardingStrategy : this.getCreateSpareStrategies()) {
                        sps.add(new Pair<MixShardingGroupTables.ShardingGroupsInovker, ShardingStrategy>(() -> AbstractShardingStrategy.lambda$null$3(pg, oldValue, shardingStrategy, (Supplier)lazyTableCache, fullShardingValueRequired, mc), shardingStrategy));
                    }
                    return sps;
                }, () -> this.noneTableShardingResultSupplier(pg));
                try {
                    ShardingGroupTable[] shardingGroupTableArray = mix.shardingGroups();
                    return shardingGroupTableArray;
                }
                finally {
                    pg.setAlwaysValue(oldValue);
                }
            }
            MixShardingSpan mss = null;
            boolean am = mc.isActionMetricEnabled();
            if (am) {
                mss = new MixShardingSpan(this, false);
                mc.actionMetric().stat(mss);
            }
            if ((pair = this.doShardingGroups(pg, lazyTableCache, fullShardingValueRequired, false, mc)).getKey().booleanValue()) {
                HashMap<String, ShardingGroupTable> retMap = null;
                for (ShardingStrategy shardingStrategy : this.getCreateSpareStrategies()) {
                    if (shardingStrategy instanceof IndexPKSpareStrategy && mc.sqlFeature().isDoUpdateIndexField()) continue;
                    pg.setAlwaysValue(oldValue);
                    Pair<Boolean, Supplier<ShardingGroupTable[]>> sparePair = ((AbstractShardingStrategy)shardingStrategy).doShardingGroups(pg, lazyTableCache, fullShardingValueRequired, true, mc);
                    if (!sparePair.getKey().booleanValue()) continue;
                    ret = sparePair.getValue().get();
                    if (mc.isPerformanceMetricEnabled()) {
                        PerformanceMetric pm = mc.performanceMetric();
                        if (shardingStrategy instanceof IndexPKSpareStrategy) {
                            pm.setUsePK(true);
                            if (am) {
                                mss.setPK(ret);
                            }
                        } else if (shardingStrategy instanceof IndexSpareStrategy) {
                            pm.setUseIndex(true);
                            if (am) {
                                mss.getIndexMap().put(shardingStrategy, ret);
                            }
                        } else {
                            pm.setPartShardingCondition(true);
                            if (am) {
                                mss.getSpareMap().put(shardingStrategy, ret);
                            }
                        }
                    }
                    if (ret.length <= 1) break;
                    HashMap<String, ShardingGroupTable> spareMap = new HashMap<String, ShardingGroupTable>(ret.length);
                    for (ShardingGroupTable sr : ret) {
                        spareMap.putIfAbsent(sr.getShardingTable(), sr);
                    }
                    if (retMap == null) {
                        retMap = spareMap;
                        continue;
                    }
                    for (String table : new ArrayList(retMap.keySet())) {
                        if (spareMap.containsKey(table)) continue;
                        retMap.remove(table);
                    }
                }
                if (retMap != null) {
                    ret = retMap.values().toArray(new ShardingGroupTable[retMap.size()]);
                }
            }
            if (ret == null) {
                ret = pair.getValue().get();
                if (am) {
                    mss.setMain(ret);
                }
            }
            if (ret.length == 1 && mc.isPerformanceMetricEnabled()) {
                mc.performanceMetric().setFullShardingCondition(true);
            }
            pg.setAlwaysValue(oldValue);
            if (!am) return ret;
            mss.setMixed(ret);
            return ret;
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Pair<Boolean, Supplier<ShardingGroupTable[]>> doShardingGroups(ParamsGroup pg, Supplier<String[]> lazyTableCache, boolean fullShardingValueRequired, boolean spareStrategy, MetricsCollector mc) throws SQLException {
        ShardingParamsCombiner spCombiner;
        Map<Long, List<ShardingParamsCombiner.ShardingParameter>> shardingMap;
        long[] shardingIndex;
        ShardingHintContext ctx = ShardingHintContext.get();
        if (ctx != null && !ctx.isSkipHint() && (shardingIndex = ctx.tryShardingIndex(this.config)) != null) {
            if (mc.isPerformanceMetricEnabled()) {
                mc.performanceMetric().setUseHint(true);
            }
            if (shardingIndex.length == 0) {
                return new Pair<Boolean, Supplier<ShardingGroupTable[]>>(true, this.noneTableShardingResultSupplier(pg));
            }
            ShardingGroupTable[] groups = new ShardingGroupTable[shardingIndex.length];
            TableName tn = TableName.of(this.config.getTable());
            int i = 0;
            for (long index : shardingIndex) {
                ShardingGroupTable group = new ShardingGroupTable(tn.getShardingTable(index));
                group.setShardingHintContext(ctx);
                for (ParamsGroup.ParameterKey pk : pg.keys()) {
                    group.addShardingFieldValue(new ShardingFieldValue(pk, pg));
                }
                groups[i++] = group;
            }
            TableManager tm = XDBConfig.getTableManager();
            for (long index : shardingIndex) {
                if (tm.existTable(tn.getShardingTable(index))) continue;
                try {
                    tm.createShardingTable(this.config.getTable(), index);
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            }
            return new Pair<Boolean, Supplier<ShardingGroupTable[]>>(true, () -> groups);
        }
        AlwaysValue alwaysValue = pg.getAlwaysValue();
        if (alwaysValue == AlwaysValue.always_true) {
            return new Pair<Boolean, Supplier<ShardingGroupTable[]>>(true, this.allTableShardingResultSupplier(pg, lazyTableCache.get()));
        }
        if (alwaysValue == AlwaysValue.always_false) {
            return new Pair<Boolean, Supplier<ShardingGroupTable[]>>(true, this.noneTableShardingResultSupplier(pg));
        }
        String[] shardingFields = this.config.getShardingFields();
        pg.reTestShardingEffectiveKeys(shardingFields);
        Set<ParamsGroup.ParameterKey> shardingEffectiveKeys = pg.shardingEffectiveKeys();
        ArrayList<ParamsGroup.ParameterKey> shardingParameters = new ArrayList<ParamsGroup.ParameterKey>(shardingEffectiveKeys.size());
        for (ParamsGroup.ParameterKey pk : shardingEffectiveKeys) {
            Object values;
            if (!this.isExplicitFilter(pk.getFilterType()) || (values = pg.get(pk)) == null || values.isEmpty()) continue;
            shardingParameters.add(pk);
        }
        if (shardingParameters.isEmpty()) {
            if (spareStrategy) {
                return empty_spare_ret_value;
            }
            if (fullShardingValueRequired) {
                throw ExceptionUtil.wrap(BosRes.get((String)"bos-xdb", (String)"AbstractShardingStrategy_2", (String)"\u5206\u7247\u5c5e\u6027{0}\u5fc5\u987b\u6709\u660e\u786e\u6709\u6548\u7684\u6761\u4ef6.", (Object[])new Object[]{Arrays.asList(shardingFields)}));
            }
        }
        boolean lackingField = shardingParameters.isEmpty();
        if (shardingFields.length > 1) {
            HashSet<String> pkFieldNameSet = new HashSet<String>(16);
            for (ParamsGroup.ParameterKey pk : shardingParameters) {
                pkFieldNameSet.add(pk.field);
            }
            if (pkFieldNameSet.size() != shardingFields.length) {
                lackingField = true;
                if (fullShardingValueRequired) {
                    throw ExceptionUtil.wrap(BosRes.get((String)"bos-xdb", (String)"AbstractShardingStrategy_4", (String)"\u5206\u7247\u7ec4\u5408\u5c5e\u6027{0}\u7f3a\u5c11\u6761\u4ef6,\u5f53\u524d\u8bed\u53e5\u53ea\u542b:{1}", (Object[])new Object[]{Arrays.asList(shardingFields), pkFieldNameSet}));
                }
            }
        }
        if (lackingField) {
            if (spareStrategy) {
                return empty_spare_ret_value;
            }
            return new Pair<Boolean, Supplier<ShardingGroupTable[]>>(false, this.allTableShardingResultSupplier(pg, lazyTableCache.get()));
        }
        if (!spareStrategy && mc.isPerformanceMetricEnabled()) {
            mc.performanceMetric().setFullShardingCondition(true);
        }
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().stat(new ShardingParameterSpan(shardingParameters));
        }
        if ((shardingMap = (spCombiner = new ShardingParamsCombiner(shardingParameters, pg, shardingFields)).combineShardingParams((fts, vs) -> this.shardingIndexUseEqCache(fts, vs, shardingFields.length), this)).isEmpty()) {
            return new Pair<Boolean, Supplier<ShardingGroupTable[]>>(true, this.noneTableShardingResultSupplier(pg));
        }
        HashMap<Long, Object> shardingTableMap = new HashMap<Long, Object>();
        StatementType statementType = pg.getStatementType();
        String originalTableName = this.config.getTable();
        switch (statementType) {
            case insert: {
                boolean mainAndIndexPK = this.isIndexPK() && this.config instanceof MainTableConfig;
                String dbRoute = null;
                if (mainAndIndexPK) {
                    HashSet<String> routes = new HashSet<String>(10);
                    for (Long l : shardingMap.keySet()) {
                        String indexDbRoute = this.config.getOptions().getIndexRoute().getRoute(l);
                        routes.add(indexDbRoute);
                    }
                    if (routes.size() > 1) {
                        StringBuilder msg = new StringBuilder(1024);
                        msg.append("Can not write more than one database: ").append(String.join((CharSequence)",", routes));
                        throw new LimitedSQLException(XDBErrorCode.xdbMultiDBWrited, msg.toString());
                    }
                    dbRoute = (String)routes.iterator().next();
                }
                TableManager tm = XDBConfig.getTableManager();
                TableName tn = TableName.of(originalTableName);
                for (Long shardingIndex3 : shardingMap.keySet()) {
                    String shardingTable = tn.getShardingTable(shardingIndex3);
                    if (!tm.existTable(shardingTable)) {
                        try {
                            tm.createShardingTable(originalTableName, shardingIndex3);
                        }
                        catch (SQLException e) {
                            throw ExceptionUtil.wrap(e);
                        }
                    }
                    shardingTableMap.put(shardingIndex3, shardingTable);
                    if (mainAndIndexPK) {
                        this.indexPKStore.insertPKShardingIndex(dbRoute, originalTableName, shardingIndex3, this.pkField, this.config.getOptions().getIndexDefines(), pg);
                        for (String tb : ((MainTableConfig)this.config).getGroupTables()) {
                            TableName itn = TableName.of(tb);
                            if (tm.existTable(itn.getShardingTable(shardingIndex3))) continue;
                            try {
                                tm.createShardingTable(tb, shardingIndex3);
                            }
                            catch (SQLException e) {
                                throw ExceptionUtil.wrap(e);
                            }
                        }
                        continue;
                    }
                    if (!(this.config instanceof ChildrenTableConfig)) continue;
                    Object currentTablePKValue = pg.get(pg.keys(((ChildrenTableConfig)this.config).getPKField()).iterator().next()).get(0);
                    this.indexPKStore.setCache(originalTableName, shardingIndex3, currentTablePKValue);
                }
                if (!mc.isPerformanceMetricEnabled()) break;
                mc.performanceMetric().setFullShardingCondition(true);
                break;
            }
            case select: 
            case delete: 
            case update: {
                TableManager tm = XDBConfig.getTableManager();
                TableName tn = TableName.of(originalTableName);
                for (Long shardingIndex4 : shardingMap.keySet()) {
                    void var21_40;
                    String string = tn.getShardingTable(shardingIndex4);
                    if (ctx != null) {
                        if (!tm.existTable(string)) {
                            try {
                                tm.createShardingTable(originalTableName, shardingIndex4);
                            }
                            catch (SQLException e) {
                                throw ExceptionUtil.wrap(e);
                            }
                        }
                    } else if (!tm.existTable(string)) {
                        String string2 = tn.getPrototypeTable();
                    }
                    shardingTableMap.put(shardingIndex4, var21_40);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"AbstractShardingStrategy_6", (String)"\u5206\u7247\u7b56\u7565\u4e0d\u652f\u6301\u7684\u8bed\u53e5\u7c7b\u578b:{0}", (Object[])new Object[]{statementType}));
            }
        }
        int i = 0;
        ShardingGroupTable[] groups = new ShardingGroupTable[shardingMap.size()];
        for (Map.Entry<Long, List<ShardingParamsCombiner.ShardingParameter>> entry : shardingMap.entrySet()) {
            Long l = entry.getKey();
            String shardingTable = (String)shardingTableMap.get(l);
            ShardingGroupTable group = new ShardingGroupTable(shardingTable);
            List<ShardingParamsCombiner.ShardingParameter> groupParams = entry.getValue();
            HashMap<ParamsGroup.ParameterKey, ShardingFieldValue> fieldValueMap = new HashMap<ParamsGroup.ParameterKey, ShardingFieldValue>(16);
            HashSet<ParamsGroup.ParameterKey> shardedPK = new HashSet<ParamsGroup.ParameterKey>(16);
            for (ShardingParamsCombiner.ShardingParameter sp : groupParams) {
                int j = 0;
                for (ParamsGroup.ParameterKey pk : sp.keys()) {
                    Object[] params = sp.getValue(j);
                    ShardingFieldValue fv = (ShardingFieldValue)fieldValueMap.get(pk);
                    if (fv == null) {
                        fv = new ShardingFieldValue(pk, Arrays.asList(params));
                        group.addShardingFieldValue(fv);
                        fieldValueMap.put(pk, fv);
                    } else {
                        List<Object> vs2 = fv.getValues();
                        for (Object p : params) {
                            if (vs2.indexOf(p) != -1) continue;
                            vs2.add(p);
                        }
                    }
                    shardedPK.add(pk);
                    ++j;
                }
            }
            for (ParamsGroup.ParameterKey pk : pg.keys()) {
                if (shardedPK.contains(pk)) continue;
                group.addShardingFieldValue(new ShardingFieldValue(pk, pg));
            }
            if (shardedPK.size() < shardingParameters.size()) {
                boolean betweenAnd = false;
                if (shardedPK.size() == 1 && shardingParameters.size() == 2) {
                    ParamsGroup.ParameterKey pk;
                    pk = (ParamsGroup.ParameterKey)shardedPK.iterator().next();
                    boolean bl = betweenAnd = pk.getFilterType() == FilterType.between_and || pk.getFilterType() == FilterType.not_between_and;
                }
                if (!betweenAnd) {
                    group.setShardingTableAsPrototypeTable(TableName.of(originalTableName).getPrototypeTable());
                }
            }
            groups[i++] = group;
        }
        return new Pair<Boolean, Supplier<ShardingGroupTable[]>>(true, () -> groups);
    }

    private Supplier<ShardingGroupTable[]> allTableShardingResultSupplier(ParamsGroup pg, String[] shardingTables) {
        if (shardingTables.length == 0) {
            pg.setAlwaysValue(AlwaysValue.always_false);
            return this.noneTableShardingResultSupplier(pg);
        }
        pg.setAlwaysValue(AlwaysValue.always_true);
        return () -> {
            ShardingHintContext ctx;
            MetricsCollector mc = MetricsCollector.getCurrent();
            if (mc.isActionMetricEnabled()) {
                mc.actionMetric().stat(ShardingAllSpan.INSTANCE);
            }
            if ((ctx = ShardingHintContext.get()) != null && !ctx.isHintForTable(this.tableName.getOriginalName())) {
                ctx = null;
            }
            ShardingGroupTable[] ret = new ShardingGroupTable[shardingTables.length];
            for (int i = 0; i < shardingTables.length; ++i) {
                ShardingGroupTable group = new ShardingGroupTable(shardingTables[i]);
                group.setShardingHintContext(ctx);
                for (ParamsGroup.ParameterKey pk : pg.keys()) {
                    group.addShardingFieldValue(new ShardingFieldValue(pk, pg));
                }
                ret[i] = group;
            }
            return ret;
        };
    }

    private Supplier<ShardingGroupTable[]> noneTableShardingResultSupplier(ParamsGroup pg) {
        if (pg.getStatementType() == StatementType.insert) {
            String hint;
            boolean missShardingFields = false;
            for (String field : this.config.getShardingFields()) {
                if (!pg.keys(field).isEmpty()) continue;
                missShardingFields = true;
            }
            if (missShardingFields) {
                throw new SQLShardingException("Insert sql miss sharding fields " + Arrays.asList(this.config.getShardingFields()) + ": " + pg);
            }
            ShardingHintContext ctx = ShardingHintContext.get();
            String string = hint = ctx == null ? "" : ", with hint " + ctx.toString();
            if (this instanceof ChildrenStrategy) {
                String parentTable = ((ChildrenTableConfig)this.config).getParent().getTable();
                throw new SQLShardingException("Insert into " + this.config.getTable() + ", but no sharding data in parent table " + parentTable + ": " + pg + hint);
            }
            throw new SQLShardingException("Insert find none shard table: " + pg + hint);
        }
        return () -> {
            ShardingGroupTable group = new ShardingGroupTable(this.tableName.getPrototypeTable());
            for (ParamsGroup.ParameterKey pk : pg.keys()) {
                group.addShardingFieldValue(new ShardingFieldValue(pk, pg));
            }
            group.setIfExistsShardingHintContext(this.tableName.getOriginalName());
            return new ShardingGroupTable[]{group};
        };
    }

    protected boolean isUseEqCache() {
        return true;
    }

    public boolean isIndexPK() {
        return this.indexPK;
    }

    public void setIndexPK(boolean indexPK) {
        this.indexPK = indexPK;
    }

    public boolean isIDSequence() {
        return this.IDSequence;
    }

    public void setIDSequence(boolean IDSequence) {
        this.IDSequence = IDSequence;
    }

    public String getPKField() {
        return this.pkField;
    }

    public IndexPKStore getIndexPKStore() {
        return this.indexPKStore;
    }

    public void setPKField(String pkField) {
        this.pkField = pkField.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<SpareStrategy> getCreateSpareStrategies() {
        if (this.config instanceof MainTableConfig) {
            if (this.spareStrategies == null) {
                Object object = this.spareStrategiesLock;
                synchronized (object) {
                    if (this.spareStrategies == null) {
                        this.spareStrategies = Collections.unmodifiableList(this.createSpareStrategies());
                    }
                }
            }
            return this.spareStrategies;
        }
        return Collections.emptyList();
    }

    protected List<SpareStrategy> createSpareStrategies() {
        ArrayList<SpareStrategy> list = new ArrayList<SpareStrategy>(2);
        if (this.config instanceof MainTableConfig && this.isIndexPK()) {
            list.add(new IndexPKSpareStrategy(this.pkField, this));
            IndexDefine[] indexDefines = this.config.getOptions().getIndexDefines();
            if (indexDefines != null && indexDefines.length > 0) {
                for (IndexDefine def : indexDefines) {
                    list.add(new IndexSpareStrategy(def.getField(), this));
                }
            }
        }
        return list;
    }

    protected abstract void onInitConfig();

    public abstract long[] shardingIndex(FilterType[] var1, Object[] var2);

    @Override
    public abstract boolean isExplicitFilter(FilterType var1);

    @Override
    public void clearCache() {
        if (!(this instanceof SpareStrategy)) {
            this.shardingIndexEqCache.clear();
            TableName.clear(this.config.getTable());
            if (this.config instanceof MainTableConfig) {
                this.indexPKStore.clear(((MainTableConfig)this.config).getGroupTables().toArray(new String[0]));
            }
        }
        for (ShardingStrategy shardingStrategy : this.getCreateSpareStrategies()) {
            shardingStrategy.clearCache();
        }
    }

    @Override
    public void onShardingDataMoved(List<ShardingDataMoveMeta> dmList) {
        if (!(this instanceof SpareStrategy) && this.config instanceof MainTableConfig) {
            String string = this.config.getTable();
            for (ShardingDataMoveMeta dm : dmList) {
                this.indexPKStore.updatePKShardingIndex(string, dm.getToShardingIndex(), dm.getPKValue());
            }
            for (ShardingConfig sc : this.config.getChildrenConfigMap().values()) {
                sc.getShardingStrategy().onShardingDataMoved(dmList);
            }
        }
        for (ShardingStrategy shardingStrategy : this.getCreateSpareStrategies()) {
            shardingStrategy.onShardingDataMoved(dmList);
        }
    }

    @Override
    public void onShardingDataMoveCommitted(List<ShardingDataMoveMeta> dmList, boolean receivedEventCall) {
        if (!(this instanceof SpareStrategy) && this.config instanceof MainTableConfig) {
            String string = this.config.getTable();
            for (ShardingDataMoveMeta dm : dmList) {
                long toShardingIndex = dm.getToShardingIndex();
                if (this.isUseEqCache()) {
                    this.shardingIndexEqCache.set(dm.getNewValues(), toShardingIndex);
                }
                this.indexPKStore.setCache(string, toShardingIndex, dm.getPKValue());
            }
            for (ShardingConfig sc : this.config.getChildrenConfigMap().values()) {
                sc.getShardingStrategy().onShardingDataMoveCommitted(dmList, receivedEventCall);
            }
        }
        for (ShardingStrategy shardingStrategy : this.getCreateSpareStrategies()) {
            shardingStrategy.onShardingDataMoveCommitted(dmList, receivedEventCall);
        }
    }

    @Override
    public long[] shardingIndexUseEqCache(FilterType[] filterTypes, Object[] values, int shardingFieldCount) {
        if (this.isUseEqCache()) {
            return this.shardingIndexEqCache.get(filterTypes, values, shardingFieldCount, () -> this.shardingIndex(filterTypes, values));
        }
        return this.shardingIndex(filterTypes, values);
    }

    private static /* synthetic */ Pair lambda$null$3(ParamsGroup pg, AlwaysValue oldValue, ShardingStrategy spareStrategy, Supplier lazyTableCache, boolean fullShardingValueRequired, MetricsCollector mc) throws SQLException {
        pg.setAlwaysValue(oldValue);
        return ((AbstractShardingStrategy)spareStrategy).doShardingGroups(pg, lazyTableCache, fullShardingValueRequired, true, mc);
    }
}

