/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.tablemanager.TableName;

public final class FilterTypeUtil {
    private static Map<Integer, FilterType[]> ftsMap = new HashMap<Integer, FilterType[]>();

    private FilterTypeUtil() {
    }

    public static FilterType[] getEqFilterTypes(int n) {
        FilterType[] filterTypes = ftsMap.get(n);
        if (filterTypes == null) {
            filterTypes = new FilterType[n];
            for (int i = 0; i < n; ++i) {
                filterTypes[i] = FilterType.eq;
            }
            ftsMap.put(n, filterTypes);
        }
        return filterTypes;
    }

    public static boolean isExplicit(FilterType filterType) {
        return filterType == FilterType.eq || filterType == FilterType.in_range;
    }

    public static boolean isExplicitNot(FilterType filterType) {
        return filterType == FilterType.not_eq || filterType == FilterType.not_in_range;
    }

    public static boolean isRange(FilterType filterType) {
        return filterType == FilterType.eq || filterType == FilterType.not_eq || filterType == FilterType.gt || filterType == FilterType.ge || filterType == FilterType.lt || filterType == FilterType.le || filterType == FilterType.between_and || filterType == FilterType.not_between_and || filterType == FilterType.in_range || filterType == FilterType.not_in_range;
    }

    public static boolean isEquals(FilterType[] filterTypes) {
        for (FilterType filterType : filterTypes) {
            if (FilterTypeUtil.isExplicit(filterType)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEquals(FilterType[] filterTypes) {
        for (FilterType filterType : filterTypes) {
            if (filterType == FilterType.not_eq || filterType == FilterType.not_in_range) continue;
            return false;
        }
        return true;
    }

    private static List<Long> getShardingIndexies(String[] shardingTables) {
        ArrayList<Long> indexies = new ArrayList<Long>(shardingTables.length);
        for (String shardingTable : shardingTables) {
            indexies.add(TableName.of(shardingTable).getShardingIndex());
        }
        return indexies;
    }

    public static long[] filterShardingTable(String[] shardingTables, FilterType ft, long shardingIndex, boolean isDateType) {
        List<Long> indexies = FilterTypeUtil.getShardingIndexies(shardingTables);
        switch (ft) {
            case eq: 
            case in_range: {
                return new long[]{shardingIndex};
            }
            case ge: {
                for (long index : new ArrayList<Long>(indexies)) {
                    if (index >= shardingIndex) continue;
                    indexies.remove(index);
                }
                break;
            }
            case gt: {
                if (isDateType) {
                    for (long index : new ArrayList<Long>(indexies)) {
                        if (index >= shardingIndex) continue;
                        indexies.remove(index);
                    }
                } else {
                    for (long index : new ArrayList<Long>(indexies)) {
                        if (index > shardingIndex) continue;
                        indexies.remove(index);
                    }
                }
                break;
            }
            case le: {
                for (long index : new ArrayList<Long>(indexies)) {
                    if (index <= shardingIndex) continue;
                    indexies.remove(index);
                }
                break;
            }
            case lt: {
                if (isDateType) {
                    for (long index : new ArrayList<Long>(indexies)) {
                        if (index <= shardingIndex) continue;
                        indexies.remove(index);
                    }
                } else {
                    for (long index : new ArrayList<Long>(indexies)) {
                        if (index < shardingIndex) continue;
                        indexies.remove(index);
                    }
                }
                break;
            }
            case not_eq: 
            case not_in_range: {
                if (isDateType) break;
                indexies.remove(shardingIndex);
                break;
            }
            default: {
                throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"FilterTypeUtil_1", (String)"\u4ee3\u7801\u9519\u8bef,\u4e0d\u5e94\u8dd1\u5230\u8fd9\u91cc:FilterType={0}", (Object[])new Object[]{ft}));
            }
        }
        long[] ret = new long[indexies.size()];
        int n = indexies.size();
        for (int i = 0; i < n; ++i) {
            ret[i] = indexies.get(i);
        }
        return ret;
    }

    public static long[] filterShardingTable(Map<String, Long> shardingKeyIndexMap, FilterType ft, String[] values, boolean isDateType, GetFieldKey gk) {
        HashSet<Long> set = new HashSet<Long>(4);
        Set<Map.Entry<String, Long>> entrySet = shardingKeyIndexMap.entrySet();
        block10: for (String value : values) {
            switch (ft) {
                case eq: 
                case in_range: {
                    for (Map.Entry<String, Long> entry : entrySet) {
                        if (!value.equals(gk.getFieldKey(entry.getKey()))) continue;
                        set.add(entry.getValue());
                    }
                    continue block10;
                }
                case not_eq: 
                case not_in_range: {
                    if (isDateType) {
                        set.addAll(shardingKeyIndexMap.values());
                        continue block10;
                    }
                    for (Map.Entry<String, Long> entry : entrySet) {
                        if (value.equals(gk.getFieldKey(entry.getKey()))) continue;
                        set.add(entry.getValue());
                    }
                    continue block10;
                }
                case gt: {
                    for (Map.Entry<String, Long> entry : entrySet) {
                        int dt = gk.getFieldKey(entry.getKey()).compareTo(value);
                        if (dt <= 0 && (!isDateType || dt != 0)) continue;
                        set.add(entry.getValue());
                    }
                    continue block10;
                }
                case ge: {
                    for (Map.Entry<String, Long> entry : entrySet) {
                        int dt = gk.getFieldKey(entry.getKey()).compareTo(value);
                        if (dt < 0) continue;
                        set.add(entry.getValue());
                    }
                    continue block10;
                }
                case lt: {
                    for (Map.Entry<String, Long> entry : entrySet) {
                        int dt = gk.getFieldKey(entry.getKey()).compareTo(value);
                        if (dt >= 0 && (!isDateType || dt != 0)) continue;
                        set.add(entry.getValue());
                    }
                    continue block10;
                }
                case le: {
                    for (Map.Entry<String, Long> entry : entrySet) {
                        int dt = gk.getFieldKey(entry.getKey()).compareTo(value);
                        if (dt > 0) continue;
                        set.add(entry.getValue());
                    }
                    continue block10;
                }
                case like: {
                    String likeValue;
                    String cpValue = value.replace("%", ".*").replace("_", ".");
                    for (Map.Entry<String, Long> entry : entrySet) {
                        likeValue = gk.getFieldKey(entry.getKey());
                        if (!likeValue.contains(value) && !likeValue.matches(cpValue)) continue;
                        set.add(entry.getValue());
                    }
                    continue block10;
                }
                case not_like: {
                    String likeValue;
                    String cpValue = value.replace("%", ".*").replace("_", ".");
                    for (Map.Entry<String, Long> entry : entrySet) {
                        likeValue = gk.getFieldKey(entry.getKey());
                        if (likeValue.contains(value) || likeValue.matches(cpValue)) continue;
                        set.add(entry.getValue());
                    }
                    continue block10;
                }
                default: {
                    throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"FilterTypeUtil_1", (String)"\u4ee3\u7801\u9519\u8bef,\u4e0d\u5e94\u8dd1\u5230\u8fd9\u91cc:FilterType={0}", (Object[])new Object[]{ft}));
                }
            }
        }
        long[] ret = new long[set.size()];
        int i = 0;
        for (Long v : set) {
            ret[i++] = v;
        }
        return ret;
    }

    static {
        for (int i = 1; i < 10; ++i) {
            FilterTypeUtil.getEqFilterTypes(i);
        }
    }

    public static interface GetFieldKey {
        public String getFieldKey(String var1);
    }
}

