/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.xdb.sharding.ShardingGroupTable;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.spare.IndexPKSpareStrategy;
import kd.bos.xdb.sharding.strategy.spare.IndexSpareStrategy;
import kd.bos.xdb.util.Pair;
import kd.bos.xdb.xpm.metrics.action.sharding.MixShardingSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

final class MixShardingGroupTables {
    private MetricsCollector mc = MetricsCollector.getCurrent();
    private MixShardingSpan mss = null;
    private boolean pm = this.mc.isPerformanceMetricEnabled();
    private ShardingGroupsInovker pkInvoker;
    private List<ShardingGroupsInovker> indexInvokers;
    private List<ShardingGroupsInovker> spareInvokers;
    private final ShardingGroupsInovker mainInvoker;
    private final ShardingStrategy mainShardingStrategy;
    private final Supplier<List<Pair<ShardingGroupsInovker, ShardingStrategy>>> spareInvokersSP;
    private final Supplier<Supplier<ShardingGroupTable[]>> noneTableShardingResultSP;

    MixShardingGroupTables(ShardingStrategy mainShardingStrategy, ShardingGroupsInovker mainInvoker, Supplier<List<Pair<ShardingGroupsInovker, ShardingStrategy>>> spareInvokersSP, Supplier<Supplier<ShardingGroupTable[]>> noneTableShardingResultSP) {
        this.mainInvoker = mainInvoker;
        this.mainShardingStrategy = mainShardingStrategy;
        this.spareInvokersSP = spareInvokersSP;
        this.noneTableShardingResultSP = noneTableShardingResultSP;
    }

    private void addSpareInvoker(ShardingGroupsInovker sgi, ShardingStrategy spareStrategy) {
        if (spareStrategy instanceof IndexPKSpareStrategy) {
            this.pkInvoker = sgi;
        } else if (spareStrategy instanceof IndexSpareStrategy) {
            if (this.indexInvokers == null) {
                this.indexInvokers = new ArrayList<ShardingGroupsInovker>(2);
            }
            this.indexInvokers.add(sgi);
        } else {
            if (this.spareInvokers == null) {
                this.spareInvokers = new ArrayList<ShardingGroupsInovker>(4);
            }
            this.spareInvokers.add(sgi);
        }
    }

    public ShardingGroupTable[] shardingGroups() throws SQLException {
        ShardingGroupTable[] ret = this.doShardingGroups();
        if (this.pm && ret.length == 1) {
            this.mc.performanceMetric().setFullShardingCondition(true);
        }
        if (this.mss != null) {
            this.mss.setMixed(ret);
        }
        return ret;
    }

    private ShardingGroupTable[] doShardingGroups() throws SQLException {
        ShardingGroupTable[] sgts;
        boolean am = this.mc.isActionMetricEnabled();
        if (am) {
            this.mss = new MixShardingSpan(this.mainShardingStrategy, true);
            this.mc.actionMetric().stat(this.mss);
        }
        Pair<Boolean, Supplier<ShardingGroupTable[]>> pair = this.mainInvoker.shardingGroups();
        Supplier<ShardingGroupTable[]> mainSP = pair.getValue();
        boolean initGroupTableMap = false;
        ShardingGroupTable[] ret = null;
        HashMap<String, ShardingGroupTable> groupTableMap = new HashMap<String, ShardingGroupTable>();
        if (pair.getKey().booleanValue()) {
            sgts = mainSP.get();
            if (am) {
                this.mss.setMain(sgts);
            }
            if ((ret = this.merge(groupTableMap, sgts, true)) != null) {
                return ret;
            }
            initGroupTableMap = true;
        }
        HashMap<ShardingGroupsInovker, ShardingStrategy> smap = null;
        if (am) {
            smap = new HashMap<ShardingGroupsInovker, ShardingStrategy>(8);
            for (Pair<ShardingGroupsInovker, ShardingStrategy> pp : this.spareInvokersSP.get()) {
                this.addSpareInvoker(pp.getKey(), pp.getValue());
                smap.put(pp.getKey(), pp.getValue());
            }
        } else {
            for (Pair<ShardingGroupsInovker, ShardingStrategy> pp : this.spareInvokersSP.get()) {
                this.addSpareInvoker(pp.getKey(), pp.getValue());
            }
        }
        if (this.pkInvoker != null && (pair = this.pkInvoker.shardingGroups()).getKey().booleanValue()) {
            if (this.pm) {
                this.mc.performanceMetric().setUsePK(true);
            }
            sgts = pair.getValue().get();
            if (am) {
                this.mss.setPK(sgts);
            }
            if ((ret = this.merge(groupTableMap, sgts, !initGroupTableMap)) != null) {
                return ret;
            }
            if (!initGroupTableMap) {
                initGroupTableMap = true;
            }
        }
        if (this.spareInvokers != null) {
            for (ShardingGroupsInovker spareInvoker : this.spareInvokers) {
                pair = spareInvoker.shardingGroups();
                if (!pair.getKey().booleanValue()) continue;
                if (this.pm) {
                    this.mc.performanceMetric().setPartShardingCondition(true);
                }
                sgts = pair.getValue().get();
                if (am) {
                    this.mss.getSpareMap().put((ShardingStrategy)smap.get(spareInvoker), sgts);
                }
                if ((ret = this.merge(groupTableMap, sgts, !initGroupTableMap)) != null) {
                    return ret;
                }
                if (initGroupTableMap) continue;
                initGroupTableMap = true;
            }
        }
        if (this.indexInvokers != null && !this.mc.sqlFeature().isDoUpdateIndexField()) {
            for (ShardingGroupsInovker spareInvoker : this.indexInvokers) {
                pair = spareInvoker.shardingGroups();
                if (!pair.getKey().booleanValue()) continue;
                if (this.pm) {
                    this.mc.performanceMetric().setUseIndex(true);
                }
                sgts = pair.getValue().get();
                if (am) {
                    this.mss.getIndexMap().put((ShardingStrategy)smap.get(spareInvoker), sgts);
                }
                if ((ret = this.merge(groupTableMap, sgts, !initGroupTableMap)) != null) {
                    return ret;
                }
                if (initGroupTableMap) continue;
                initGroupTableMap = true;
            }
        }
        if (!initGroupTableMap) {
            if (ret == null) {
                ret = mainSP.get();
                if (am) {
                    this.mss.setMain(ret);
                }
            }
            return ret;
        }
        return groupTableMap.values().toArray(new ShardingGroupTable[groupTableMap.size()]);
    }

    private ShardingGroupTable[] merge(Map<String, ShardingGroupTable> groupTableMap, ShardingGroupTable[] gs, boolean initGroupTableMap) throws SQLException {
        if (initGroupTableMap) {
            for (ShardingGroupTable g : gs) {
                groupTableMap.put(g.getShardingTable(), g);
            }
        } else {
            HashSet<String> shardingTables = new HashSet<String>(gs.length);
            for (ShardingGroupTable g : gs) {
                shardingTables.add(g.getShardingTable());
            }
            groupTableMap.keySet().removeIf(k -> !shardingTables.contains(k));
        }
        if (groupTableMap.isEmpty()) {
            return this.noneTableShardingResultSP.get().get();
        }
        if (groupTableMap.size() == 1) {
            return groupTableMap.values().toArray(new ShardingGroupTable[groupTableMap.size()]);
        }
        return null;
    }

    static interface ShardingGroupsInovker {
        public Pair<Boolean, Supplier<ShardingGroupTable[]>> shardingGroups() throws SQLException;
    }
}

