/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.strategy.ShardingKeyGather;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.SupportBatchLikeSharding;

public final class ShardingAlgorithms {
    public static Map<Long, List<Object[]>> descartes(ShardingStrategy shardingStrategy, ShardingKeyGather g, FilterType[] filterTypes, Object[] ... params) {
        boolean bl;
        ArrayList<ShardingItem> siList = new ArrayList<ShardingItem>();
        int cols = params.length;
        if (cols == 1) {
            if (shardingStrategy.isSupportBatchShardingIndex() && (filterTypes[0] == FilterType.eq || filterTypes[0] == FilterType.in_range || filterTypes[0] == FilterType.like && shardingStrategy instanceof SupportBatchLikeSharding)) {
                long[] lArray = g.keys(filterTypes, params[0]);
                siList.add(new ShardingItem(lArray, params[0]));
            } else {
                for (Object value : params[0]) {
                    Object[] ps = new Object[]{value};
                    long[] keys = g.keys(filterTypes, ps);
                    siList.add(new ShardingItem(keys, ps));
                }
            }
        } else {
            int endRound;
            int[] nArray = new int[cols];
            Arrays.fill(nArray, 0);
            do {
                Object[] ps = new Object[cols];
                endRound = 0;
                block2: for (int col = 0; col < cols; ++col) {
                    int i = nArray[col];
                    ps[col] = params[col][i];
                    if (col != cols - 1) continue;
                    if (i + 1 == params[col].length) {
                        nArray[col] = 0;
                        if (col == 0) {
                            endRound = 1;
                            break;
                        }
                        for (int k = col - 1; k >= 0; --k) {
                            int v2 = nArray[k];
                            if (v2 + 1 == params[k].length) {
                                if (k == 0) {
                                    endRound = 1;
                                    continue block2;
                                }
                            } else {
                                nArray[k] = v2 + 1;
                                continue block2;
                            }
                            nArray[k] = 0;
                        }
                        continue;
                    }
                    nArray[col] = i + 1;
                }
                long[] keys = g.keys(filterTypes, ps);
                siList.add(new ShardingItem(keys, ps));
            } while (endRound == 0);
        }
        boolean bl2 = false;
        if (shardingStrategy.notValueExcludeSharding()) {
            for (FilterType filterType : filterTypes) {
                if (filterType != FilterType.not_in_range) continue;
                bl = true;
                break;
            }
        }
        TreeMap<Long, List<Object[]>> ret = new TreeMap<Long, List<Object[]>>();
        if (bl) {
            int shouldPresentCount = siList.size();
            HashMap<Long, Integer> presentCountMap = new HashMap<Long, Integer>();
            for (ShardingItem si : siList) {
                long[] v2 = si.indexies;
                int n = v2.length;
                for (int i = 0; i < n; ++i) {
                    Long index = v2[i];
                    Integer count = presentCountMap.computeIfAbsent(index, v -> 0) + 1;
                    presentCountMap.put(index, count);
                }
            }
            HashSet indexSet = new HashSet(presentCountMap.size());
            for (Map.Entry entry : presentCountMap.entrySet()) {
                if ((Integer)entry.getValue() != shouldPresentCount) continue;
                indexSet.add(entry.getKey());
            }
            for (ShardingItem si : siList) {
                long[] lArray = si.indexies;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long index = lArray[i];
                    if (!indexSet.contains(index)) continue;
                    ArrayList<Object[]> list = (ArrayList<Object[]>)ret.get(index);
                    if (list == null) {
                        list = new ArrayList<Object[]>();
                        ret.put(index, list);
                    }
                    list.add(si.params);
                }
            }
        } else {
            for (ShardingItem si : siList) {
                long[] lArray = si.indexies;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long index = lArray[i];
                    ArrayList<Object[]> list = (ArrayList<Object[]>)ret.get(index);
                    if (list == null) {
                        list = new ArrayList<Object[]>();
                        ret.put(index, list);
                    }
                    list.add(si.params);
                }
            }
        }
        return ret;
    }

    private static class ShardingItem {
        private long[] indexies;
        private Object[] params;

        ShardingItem(long[] indexies, Object[] params) {
            this.indexies = indexies;
            this.params = params;
        }
    }
}

