/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.cache.CacheContext;
import kd.bos.xdb.ext.SelfSetParameter;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.xpm.metrics.action.sharding.shardingfields.ClearShardingFieldsCacheSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.shardingfields.HitShardingFieldCacheSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;
import org.apache.curator.shaded.com.google.common.base.Objects;

public final class ShardingFieldsCache {
    private static final AtomicLong idSeq = new AtomicLong();
    private final long id = idSeq.incrementAndGet();
    private final String cache_key_type = "EQ-" + this.id;
    private final ShardingStrategy shardingStrategy;
    private String name;

    public ShardingFieldsCache(ShardingStrategy shardingStrategy) {
        this.shardingStrategy = shardingStrategy;
    }

    public void setName(String name) {
        this.name = name;
        CacheContext.get().getCurrentCache().initCacheSize(this.cache_key_type, XDBConfig.get().getCacheShardingFieldValueSize());
    }

    public String getName() {
        return this.cache_key_type;
    }

    public String toString() {
        return ShardingFieldsCache.class.getSimpleName() + '#' + this.name + '#' + this.cache_key_type;
    }

    public void clear() {
        CacheContext.get().getCurrentCache().clear(this.cache_key_type);
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            ShardingConfig config = this.shardingStrategy.getConfig();
            mc.actionMetric().stat(new ClearShardingFieldsCacheSpan(config.getTable(), config.getShardingFields()));
        }
    }

    long[] get(FilterType[] filterTypes, Object[] values, int shardingFieldCount, Supplier<long[]> sp) {
        boolean useCache;
        boolean bl = useCache = shardingFieldCount == filterTypes.length && (filterTypes.length != 1 || filterTypes.length == 1 && values.length == 1);
        if (useCache && this.isEqFilterTypes(filterTypes)) {
            ShardingFieldsCacheKey cacheKey = new ShardingFieldsCacheKey(values);
            Long index = (Long)CacheContext.get().getCurrentCache().get(this.cache_key_type, cacheKey);
            if (index != null) {
                MetricsCollector mc = MetricsCollector.getCurrent();
                if (mc.isActionMetricEnabled()) {
                    ShardingConfig config = this.shardingStrategy.getConfig();
                    mc.actionMetric().stat(new HitShardingFieldCacheSpan(config.getTable(), config.getShardingFields(), values, index));
                }
                return new long[]{index};
            }
            long[] ret = sp.get();
            if (ret != null && ret.length == 1) {
                CacheContext.get().getCurrentCache().set(this.cache_key_type, cacheKey, ret[0]);
            }
            return ret;
        }
        return sp.get();
    }

    public void set(Object[] values, long shardingIndex) {
        CacheContext.get().getCurrentCache().set(this.cache_key_type, new ShardingFieldsCacheKey(values), shardingIndex);
    }

    private boolean isEqFilterTypes(FilterType[] filterTypes) {
        for (FilterType ft : filterTypes) {
            if (ft == FilterType.eq || ft == FilterType.in_range) continue;
            return false;
        }
        return true;
    }

    public static class ShardingFieldsCacheKey {
        private final int hashCode;
        private final Object[] values;

        ShardingFieldsCacheKey(Object[] values) {
            this.values = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.values[i] = values[i] instanceof SelfSetParameter ? ((SelfSetParameter)values[i]).getValue() : values[i];
                if (this.values[i] instanceof String) continue;
                this.values[i] = String.valueOf(this.values[i]);
            }
            this.hashCode = Arrays.hashCode(this.values);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ShardingFieldsCacheKey) {
                int n;
                ShardingFieldsCacheKey sk = (ShardingFieldsCacheKey)obj;
                if (this.hashCode == sk.hashCode && (n = this.values.length) == sk.values.length) {
                    if (n == 1) {
                        return Objects.equal((Object)this.values[0], (Object)sk.values[0]);
                    }
                    for (int i = 0; i < n; ++i) {
                        if (Objects.equal((Object)this.values[i], (Object)sk.values[i])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return Arrays.toString(this.values);
        }
    }
}

