/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.cache;

import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.eventbus.EventBus;
import kd.bos.xdb.eventbus.EventHandler;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.strategy.cache.ClearShardingStrategyCacheAckEvent;
import kd.bos.xdb.sharding.strategy.cache.ClearShardingStrategyCacheEvent;

final class ClearShardingStrategyCacheEventHandler
implements EventHandler<ClearShardingStrategyCacheEvent> {
    ClearShardingStrategyCacheEventHandler() {
    }

    @Override
    public void handle(ClearShardingStrategyCacheEvent event) {
        ClearShardingStrategyCacheEventHandler.clearCache(event.getTableName());
        EventBus.publish("xdb-strategy-cache", new ClearShardingStrategyCacheAckEvent(event.getId()));
    }

    static void clearCache(String tableName) {
        ShardingConfig config = XDBConfig.getShardingConfigProvider().getConfig(tableName);
        if (config != null) {
            while (config instanceof ChildrenTableConfig) {
                config = ((ChildrenTableConfig)config).getParent();
            }
            config.getShardingStrategy().clearCache();
            for (ShardingConfig cc : ((MainTableConfig)config).getChildrenConfigMap().values()) {
                cc.getShardingStrategy().clearCache();
            }
        }
    }
}

