/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.date;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.KSQLTimePatternFormatter;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.FilterTypeUtil;
import kd.bos.xdb.sharding.strategy.map.DateTimeEdge;
import kd.bos.xdb.util.DateUtil;

public abstract class BaseDateStrategy
extends AbstractShardingStrategy {
    protected final String dateFormatPattern;

    public BaseDateStrategy(String dateFormatPattern) {
        Objects.requireNonNull(dateFormatPattern);
        this.dateFormatPattern = dateFormatPattern;
    }

    @Override
    protected void onInitConfig() {
        String[] shardingFields = this.config.getShardingFields();
        if (!this.singleShardingField) {
            throw new IllegalArgumentException("XDB only support one sharding field on Date or IDSequence type: " + Arrays.asList(shardingFields));
        }
    }

    @Override
    public boolean notValueExcludeSharding() {
        return true;
    }

    protected long calcIndex(Object value) {
        if (value == null) {
            return 0L;
        }
        return Long.parseLong(DateUtil.getDateFormat(this.dateFormatPattern).format((Date)value));
    }

    protected Object getDateObj(Object value) {
        return value;
    }

    @Override
    public long[] shardingIndex(FilterType[] filterTypes, Object[] values) {
        Date dt;
        FilterType ft = filterTypes[0];
        if (values[0] instanceof String) {
            KSQLTimePatternFormatter ksqlTimePatternFormatter = new KSQLTimePatternFormatter((String)values[0]);
            Object object = values[0] = ksqlTimePatternFormatter.isKSQLTimePattern() ? ksqlTimePatternFormatter.getKSQLTimePatternToDate() : values[0];
        }
        if ((dt = (Date)this.getDateObj(values[0])) != null && (ft == FilterType.lt || ft == FilterType.gt)) {
            if (ft == FilterType.lt) {
                ft = FilterType.le;
                dt = DateTimeEdge.before(dt);
            } else {
                ft = FilterType.ge;
                dt = DateTimeEdge.after(dt);
            }
        }
        long index = this.calcIndex(dt);
        if (ft == FilterType.eq || ft == FilterType.in_range) {
            return new long[]{index};
        }
        return FilterTypeUtil.filterShardingTable(this.getAllShardingTablesUseHintContext(true), ft, index, true);
    }

    @Override
    public boolean isExplicitFilter(FilterType filterType) {
        return filterType == FilterType.eq || filterType == FilterType.gt || filterType == FilterType.ge || filterType == FilterType.lt || filterType == FilterType.le || filterType == FilterType.between_and || filterType == FilterType.like;
    }

    @Override
    public String[] getAllShardingTables(boolean onlyExists) {
        try {
            return XDBConfig.getTableManager().getShardingTable(this.config.getTable());
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }
}

