/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.id;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.SelfSetParameter;
import kd.bos.xdb.id.IDUtil;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.strategy.FilterTypeUtil;
import kd.bos.xdb.sharding.strategy.date.BaseDateStrategy;

public class IDSequenceStrategy
extends BaseDateStrategy {
    private static Date noneDateValue;

    public IDSequenceStrategy(String dateFormatPattern) {
        super(dateFormatPattern.replaceAll("-", ""));
    }

    @Override
    public Object getDateObj(Object value) {
        if (value == null) {
            return noneDateValue;
        }
        if (value instanceof SelfSetParameter) {
            value = ((SelfSetParameter)value).getValue();
        }
        if (value instanceof Number) {
            long v = ((Number)value).longValue();
            if (v <= 0L) {
                return noneDateValue;
            }
            return IDUtil.getCreateTime(v);
        }
        if (((String)value).length() <= 1) {
            return noneDateValue;
        }
        return IDUtil.getCreateTime((String)value);
    }

    @Override
    public boolean isExplicitFilter(FilterType filterType) {
        return FilterTypeUtil.isExplicit(filterType);
    }

    static {
        try {
            noneDateValue = new SimpleDateFormat("yyyy-MM-dd").parse("2017-01-01");
        }
        catch (ParseException e) {
            throw ExceptionUtil.asRuntimeException(e);
        }
    }
}

