/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.map;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.xdb.engine.ShardingContext;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.KSQLTimePatternFormatter;
import kd.bos.xdb.sharding.config.FieldType;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.strategy.FilterTypeUtil;
import kd.bos.xdb.sharding.strategy.map.DateTimeEdge;
import kd.bos.xdb.sharding.strategy.map.EqLikeValue;
import kd.bos.xdb.sharding.strategy.map.MapStrategy;
import kd.bos.xdb.sharding.strategy.map.ShardingIndexMap;
import kd.bos.xdb.sharding.strategy.map.mapper.ValueMapper;
import kd.bos.xdb.sharding.strategy.spare.SpareStrategy;
import kd.bos.xdb.util.DateUtil;

class MapSpareStrategy
extends SpareStrategy {
    private final String field;
    private final FieldType fieldType;
    private final int fieldIndex;
    private final String delim;
    private final String pattern;
    private final EqLikeValue eqLikeValue;
    private final ValueMapper keyMapper;

    public MapSpareStrategy(int fieldIndex, String field, FieldType fieldType, String delim, String pattern, EqLikeValue eqLikeValue, ValueMapper keyMapper, MapStrategy mainStrategy) {
        super(new String[]{field}, mainStrategy);
        this.field = field;
        this.fieldType = fieldType;
        this.fieldIndex = fieldIndex;
        this.delim = delim;
        this.pattern = pattern;
        this.eqLikeValue = eqLikeValue;
        this.keyMapper = keyMapper;
    }

    protected String getFieldKey(String key) {
        return key.split(this.delim)[this.fieldIndex];
    }

    private String getFormattedValue(Object value, boolean isDateType) {
        if (this.keyMapper != null) {
            value = this.keyMapper.mapValue(this.fieldIndex, this.field, this.fieldType, value);
        } else {
            if (value == null) {
                return "null";
            }
            if (isDateType) {
                SimpleDateFormat sdf = DateUtil.getDateFormat(this.pattern);
                if (value instanceof Date) {
                    return sdf.format((Date)value);
                }
                try {
                    KSQLTimePatternFormatter ksqlTimePatternFormatter;
                    if (value instanceof String && (ksqlTimePatternFormatter = new KSQLTimePatternFormatter((String)value)).isKSQLTimePattern()) {
                        return sdf.format(ksqlTimePatternFormatter.getKSQLTimePatternToDate());
                    }
                    return sdf.format(sdf.parse(String.valueOf(value)));
                }
                catch (ParseException e) {
                    throw ExceptionUtil.wrap("Date format error(" + this.pattern + "):" + value, e);
                }
            }
        }
        return String.valueOf(value);
    }

    @Override
    public long[] shardingIndex(FilterType[] filterTypes, Object[] values) {
        return this.doShardingIndex(filterTypes, values, null);
    }

    long[] doShardingIndex(FilterType[] filterTypes, Object[] values, Supplier<Map<String, Long>> shardingKeyIndexMapSupplier) {
        int i;
        boolean isDateType;
        int N = values.length;
        FilterType ft = filterTypes[0];
        boolean bl = isDateType = this.fieldType == FieldType.DATE;
        if (isDateType && values[0] instanceof Date && (ft == FilterType.lt || ft == FilterType.gt)) {
            Date dt;
            Object[] buf = new Object[N];
            if (ft == FilterType.lt) {
                ft = FilterType.le;
                for (i = 0; i < N; ++i) {
                    dt = (Date)values[i];
                    if (dt != null) {
                        dt = DateTimeEdge.before(dt);
                    }
                    buf[i] = dt;
                }
            } else {
                ft = FilterType.ge;
                for (i = 0; i < N; ++i) {
                    dt = (Date)values[i];
                    if (dt != null) {
                        dt = DateTimeEdge.after(dt);
                    }
                    buf[i] = dt;
                }
            }
            values = buf;
        }
        String[] eqKeys = new String[N];
        for (int i2 = 0; i2 < N; ++i2) {
            eqKeys[i2] = this.getFormattedValue(values[i2], isDateType);
        }
        if (ft == FilterType.eq || ft == FilterType.in_range) {
            if (this.eqLikeValue == null) {
                return ShardingIndexMap.get(this.config.getTable()).queryShardingIndexEq(eqKeys);
            }
            Object[] likeKeys = new Object[N];
            for (i = 0; i < N; ++i) {
                likeKeys[i] = this.eqLikeValue.like(eqKeys[i]);
            }
            shardingKeyIndexMapSupplier = () -> ShardingIndexMap.get(this.config.getTable()).queryShardingIndexLike(likeKeys);
        }
        if (shardingKeyIndexMapSupplier == null) {
            shardingKeyIndexMapSupplier = () -> ShardingIndexMap.get(this.config.getTable()).queryAllShardingMapTables(ShardingContext.get().getStatementType() == StatementType.select);
        }
        return FilterTypeUtil.filterShardingTable(shardingKeyIndexMapSupplier.get(), ft, eqKeys, isDateType, key -> this.getFieldKey(key));
    }

    @Override
    public boolean isExplicitFilter(FilterType filterType) {
        if (this.keyMapper == null) {
            return filterType != FilterType.other;
        }
        return FilterTypeUtil.isExplicit(filterType);
    }

    @Override
    public boolean isSupportBatchShardingIndex() {
        return true;
    }
}

