/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.map;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.engine.ShardingContext;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.KSQLTimePatternFormatter;
import kd.bos.xdb.sharding.config.FieldType;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.sql.dml.update.ShardingDataMoveMeta;
import kd.bos.xdb.sharding.strategy.BaseCustomStrategy;
import kd.bos.xdb.sharding.strategy.FilterTypeUtil;
import kd.bos.xdb.sharding.strategy.WithMapTableStrategy;
import kd.bos.xdb.sharding.strategy.map.EqLikeValue;
import kd.bos.xdb.sharding.strategy.map.MapFieldSpareStrategy;
import kd.bos.xdb.sharding.strategy.map.MapSpareStrategy;
import kd.bos.xdb.sharding.strategy.map.ShardingIndexMap;
import kd.bos.xdb.sharding.strategy.map.mapper.AbstractValueMapper;
import kd.bos.xdb.sharding.strategy.map.mapper.ValueMapper;
import kd.bos.xdb.sharding.strategy.spare.SpareStrategy;
import kd.bos.xdb.util.ArrayUtil;
import kd.bos.xdb.util.DateUtil;

public class MapStrategy
extends BaseCustomStrategy
implements WithMapTableStrategy {
    private static final String PARAMETER_KEY_PROPERTY_ORDER_PREFIX = "p";
    private static final String PARAMETER_KEY_FIELD_DELIM = "delim";
    private static final String PARAMETER_KEY_DATEPATTERN = "pattern";
    private static final String PARAMETER_KEY_VALUEMAPPER = "valueMapper";
    private String delim;
    private String[] datePatterns;
    private ValueMapper[] valueMappers;
    private MapSpareStrategy oneFieldStrategy;
    private final String likePrefix;
    private final String likeSuffix;
    private String[] fields;
    private FieldType[] fieldTypes;
    private String[] retainIndexFields;
    private boolean withMapper = false;

    public MapStrategy(Map<String, String> paramMap) {
        super(paramMap);
        this.delim = paramMap.get(PARAMETER_KEY_FIELD_DELIM);
        if (this.delim == null || this.delim.trim().isEmpty()) {
            this.delim = "#";
        } else {
            this.delim = this.delim.trim();
            if (this.delim.contains("_") || this.delim.contains("%")) {
                throw new IllegalArgumentException("delim can't contains _ or %: " + this.delim);
            }
        }
        this.likePrefix = '%' + this.delim;
        this.likeSuffix = this.delim + '%';
    }

    @Override
    protected void onInitConfig() {
        this.fields = this.config.getShardingFields();
        int n = this.fields.length;
        this.fieldTypes = new FieldType[n];
        int m = 0;
        for (String field : this.fields) {
            this.fieldTypes[m++] = this.config.getOptions().getShardingFieldDefines(field).getType();
        }
        this.datePatterns = new String[n];
        String defaultDatePattern = (String)this.paramMap.get(PARAMETER_KEY_DATEPATTERN);
        for (int i = 0; i < n; ++i) {
            this.datePatterns[i] = this.paramMap.getOrDefault(PARAMETER_KEY_PROPERTY_ORDER_PREFIX + (i + 1) + '.' + PARAMETER_KEY_DATEPATTERN, defaultDatePattern);
            if (!StringUtils.isEmpty((String)this.datePatterns[i])) continue;
            this.datePatterns[i] = null;
        }
        ValueMapper defaultValueMapper = this.createValueMapper(PARAMETER_KEY_VALUEMAPPER);
        this.valueMappers = new ValueMapper[n];
        for (int i = 0; i < n; ++i) {
            this.valueMappers[i] = this.createValueMapper(PARAMETER_KEY_PROPERTY_ORDER_PREFIX + (i + 1) + '.' + PARAMETER_KEY_VALUEMAPPER);
            if (this.valueMappers[i] != null || defaultValueMapper == null) continue;
            this.valueMappers[i] = defaultValueMapper;
        }
        if (n == 1) {
            this.oneFieldStrategy = new MapSpareStrategy(0, this.fields[0], this.config.getOptions().getShardingFieldDefines(this.fields[0]).getType(), this.delim, this.datePatterns[0], null, this.valueMappers[0], this){

                @Override
                protected String getFieldKey(String key) {
                    return key;
                }
            };
        }
        for (ValueMapper vp : this.valueMappers) {
            if (vp == null) continue;
            this.withMapper = true;
            break;
        }
    }

    private ValueMapper createValueMapper(String pkey) {
        String mapperCls = (String)this.paramMap.get(pkey);
        if (mapperCls != null && mapperCls.trim().length() > 0) {
            try {
                Class<?> cls = Class.forName(mapperCls.trim());
                if (AbstractValueMapper.class.isAssignableFrom(cls)) {
                    HashMap mapperParamMap = new HashMap();
                    for (Map.Entry entry : this.paramMap.entrySet()) {
                        if (!((String)entry.getKey()).startsWith(pkey + '.')) continue;
                        mapperParamMap.put(((String)entry.getKey()).substring(pkey.length() + 1), entry.getValue());
                    }
                    return (ValueMapper)cls.getConstructor(Map.class).newInstance(mapperParamMap);
                }
                return (ValueMapper)cls.newInstance();
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    Throwable target = ((InvocationTargetException)e).getTargetException();
                    throw ExceptionUtil.wrap(target);
                }
                throw ExceptionUtil.wrap(e);
            }
        }
        return null;
    }

    @Override
    protected List<SpareStrategy> createSpareStrategies() {
        List<SpareStrategy> ret = super.createSpareStrategies();
        int n = this.fields.length;
        if (n > 1) {
            for (int i = 0; i < n; ++i) {
                EqLikeValue lv = i == 0 ? k -> k + this.likeSuffix : (i == n - 1 ? k -> this.likePrefix + k : k -> this.likePrefix + k + this.likeSuffix);
                ret.add(new MapFieldSpareStrategy(i, this.fields[i], this.config.getOptions().getShardingFieldDefines(this.fields[i]).getType(), this.delim, this.datePatterns[i], lv, this.valueMappers[i], this));
            }
        }
        return ret;
    }

    @Override
    public String[] getAllShardingTables(boolean onlyExists) {
        try {
            return XDBConfig.getTableManager().getShardingTable(this.config.getTable());
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    private String getFormattedValue(int fieldIndex, String field, FieldType fieldType, Object value) {
        if (this.valueMappers[fieldIndex] != null) {
            value = this.valueMappers[fieldIndex].mapValue(fieldIndex, field, fieldType, value);
        }
        if (value == null) {
            return "null";
        }
        if (fieldType == FieldType.STRING && value instanceof String && StringUtils.isBlank((String)((String)value))) {
            return StringUtils.getEmpty();
        }
        if (fieldType == FieldType.DATE) {
            SimpleDateFormat sdf = DateUtil.getDateFormat(this.datePatterns[fieldIndex]);
            if (value instanceof Date) {
                return sdf.format((Date)value);
            }
            try {
                KSQLTimePatternFormatter ksqlTimePatternFormatter;
                if (value instanceof String && (ksqlTimePatternFormatter = new KSQLTimePatternFormatter((String)value)).isKSQLTimePattern()) {
                    return sdf.format(ksqlTimePatternFormatter.getKSQLTimePatternToDate());
                }
                return sdf.format(sdf.parse(String.valueOf(value)));
            }
            catch (ParseException e) {
                throw ExceptionUtil.wrap("Date format error(" + this.datePatterns[fieldIndex] + "):" + value, e);
            }
        }
        return String.valueOf(value);
    }

    String genKey(Object[] values) {
        int N = values.length;
        StringBuilder key = new StringBuilder(32 * N);
        for (int i = 0; i < N; ++i) {
            if (i > 0) {
                key.append(this.delim);
            }
            key.append(this.getFormattedValue(i, this.fields[i], this.fieldTypes[i], values[i]));
        }
        return key.toString();
    }

    @Override
    public long[] shardingIndex(FilterType[] filterTypes, Object[] values) {
        boolean eq = true;
        for (FilterType ft : filterTypes) {
            if (ft == FilterType.eq || ft == FilterType.in_range) continue;
            eq = false;
            break;
        }
        if (eq) {
            long[] lArray;
            boolean batch;
            boolean bl = batch = filterTypes.length == 1 && values.length > 1;
            if (batch) {
                String[] eqKeys = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    eqKeys[i] = this.genKey(new Object[]{values[i]});
                }
                return ShardingIndexMap.get(this.config.getTable()).queryShardingIndexEq(eqKeys);
            }
            String key = this.genKey(values);
            Long shardingIndex = ShardingIndexMap.get(this.config.getTable()).getOrSetShardingIndex(key);
            if (shardingIndex == null) {
                lArray = ArrayUtil.EMPTY_INDEXIES;
            } else {
                long[] lArray2 = new long[1];
                lArray = lArray2;
                lArray2[0] = shardingIndex;
            }
            return lArray;
        }
        int N = filterTypes.length;
        if (N == 1) {
            return this.oneFieldStrategy.shardingIndex(filterTypes, values);
        }
        Supplier<Map<String, Long>> shardingKeyIndexMapSupplier = new Supplier<Map<String, Long>>(){
            private Map<String, Long> map;

            @Override
            public Map<String, Long> get() {
                if (this.map == null) {
                    this.map = ShardingIndexMap.get(MapStrategy.this.config.getTable()).queryAllShardingMapTables(ShardingContext.get().getStatementType() == StatementType.select);
                }
                return this.map;
            }
        };
        HashSet<Long> set = new HashSet<Long>(4);
        List<SpareStrategy> spareStrategies = this.getCreateSpareStrategies();
        int from = spareStrategies.size() - N;
        for (int i = 0; i < N; ++i) {
            MapFieldSpareStrategy ss = (MapFieldSpareStrategy)spareStrategies.get(i + from);
            long[] shardingIndex = ss.doShardingIndex(new FilterType[]{filterTypes[i]}, new Object[]{values[i]}, shardingKeyIndexMapSupplier);
            if (i == 0) {
                for (long v : shardingIndex) {
                    set.add(v);
                }
                continue;
            }
            ArrayList<Long> newList = new ArrayList<Long>(shardingIndex.length);
            for (long v : shardingIndex) {
                newList.add(v);
            }
            set.retainAll(newList);
        }
        long[] ret = new long[set.size()];
        int i = 0;
        for (Long v : set) {
            ret[i++] = v;
        }
        return ret;
    }

    @Override
    public boolean isExplicitFilter(FilterType filterType) {
        if (this.withMapper) {
            return FilterTypeUtil.isExplicit(filterType);
        }
        return filterType != FilterType.other;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        ShardingIndexMap.get(this.config.getTable()).clear();
    }

    @Override
    public void onShardingDataMoved(List<ShardingDataMoveMeta> dmList) {
        super.onShardingDataMoved(dmList);
    }

    @Override
    public void onShardingDataMoveCommitted(List<ShardingDataMoveMeta> dmList, boolean receivedEventCall) {
        super.onShardingDataMoveCommitted(dmList, receivedEventCall);
        ShardingIndexMap shardingIndexMap = ShardingIndexMap.get(this.config.getTable());
        for (ShardingDataMoveMeta dm : dmList) {
            shardingIndexMap.setCache(this.genKey(dm.getNewValues()), dm.getToShardingIndex());
        }
    }

    @Override
    public boolean isSupportBatchShardingIndex() {
        return true;
    }

    public ValueMapper[] getValueMappers() {
        return this.valueMappers;
    }

    public String[] getRetainIndexFields() {
        return this.retainIndexFields;
    }

    public void setRetainIndexFields(String[] retainIndexFields) {
        this.retainIndexFields = new String[retainIndexFields.length];
        int k = 0;
        block0: for (int j = 0; j < this.fields.length; ++j) {
            for (int i = 0; i < retainIndexFields.length; ++i) {
                if (!retainIndexFields[i].equalsIgnoreCase(this.fields[j])) continue;
                this.retainIndexFields[k++] = this.fields[j];
                continue block0;
            }
        }
    }
}

