/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.map;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.XDBManageContext;
import kd.bos.xdb.dlock.DLock;
import kd.bos.xdb.engine.ShardingContext;
import kd.bos.xdb.engine.ShardingEngineFactory;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.ArrayUtil;
import kd.bos.xdb.xpm.metrics.action.sharding.index.ClearIndexMapCacheSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.spare.HitIndexMapCacheSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.spare.InsertIndexMapSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.spare.QueryLikeIndexMapSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public final class ShardingIndexMap
implements XDBLogable {
    private static Map<String, ShardingIndexMap> tableMap = new ConcurrentHashMap<String, ShardingIndexMap>();
    private final String table;
    private final String mapTable;
    private final String insertShardingIndexSQL;
    private final String queryAllShardingMapTablesSQL;
    private final String queryMaxShardingIndexSQL;
    private final int batchSize = XDBConfig.get().getQueryIndexBatchSize();
    private Map<String, Long> globalIndexMap = new ConcurrentHashMap<String, Long>();
    private AtomicLong version = new AtomicLong(0L);
    private Map<String, Long> indexMap = new ConcurrentHashMap<String, Long>();

    public static ShardingIndexMap get(String table) {
        String ltable = table.toLowerCase();
        String key = ShardingEngineFactory.get().getShardingConfigProvider().getContextKey() + '#' + ltable;
        ShardingIndexMap sim = tableMap.get(key);
        return sim != null ? sim : tableMap.computeIfAbsent(key, k -> new ShardingIndexMap(ltable));
    }

    private ShardingIndexMap(String table) {
        this.table = table;
        this.mapTable = TableName.of(table).getMapTable();
        this.insertShardingIndexSQL = KSQL.dialect(NoShardingHint.genNoShardingSQL("insert into " + this.mapTable + "(fkey,findex) values (?,?)"));
        this.queryAllShardingMapTablesSQL = KSQL.dialect(NoShardingHint.genNoShardingSQL("select fkey,findex from " + this.mapTable));
        this.queryMaxShardingIndexSQL = KSQL.dialect(NoShardingHint.genNoShardingSQL("select max(findex) from " + this.mapTable));
    }

    public void setCache(String key, Long index) {
        this.indexMap.put(key, index);
        if (this.globalIndexMap != this.indexMap) {
            this.globalIndexMap.put(key, index);
        }
    }

    public void clear() {
        MetricsCollector mc;
        this.indexMap.clear();
        if (this.globalIndexMap != this.indexMap) {
            this.globalIndexMap.clear();
        }
        if ((mc = MetricsCollector.getCurrent()).isActionMetricEnabled()) {
            mc.actionMetric().stat(new ClearIndexMapCacheSpan(this.mapTable));
        }
    }

    public String toString() {
        return this.table;
    }

    public Long getOrSetShardingIndex(String key) {
        Long index = this._queryShardingIndex(key);
        if (index != null) {
            return index;
        }
        if (ShardingContext.get().shouldGenShardingIndex()) {
            try {
                return DLock.lock("/xdb/getOrSetShardingIndex/" + this.table, () -> {
                    Long index2 = this._queryShardingIndex(key);
                    if (index2 == null) {
                        index2 = this._queryMaxShardingIndex(key) + 1L;
                        this._insertShardingIndex(key, index2);
                    }
                    return index2;
                });
            }
            catch (Exception e) {
                index = this._queryShardingIndex(key);
                if (index != null) {
                    return index;
                }
                throw ExceptionUtil.wrap(e);
            }
        }
        return null;
    }

    public long[] queryShardingIndexEq(String ... eqKeys) {
        HashSet<Long> ret = new HashSet<Long>(4);
        for (String key : eqKeys) {
            Long index = this._queryShardingIndex(key);
            if (index == null) continue;
            ret.add(index);
        }
        return ArrayUtil.toArray(ret);
    }

    public Map<String, Long> queryShardingIndexLike(Object ... likeKeys) {
        if (likeKeys.length != 1) {
            likeKeys = new HashSet<Object>(Arrays.asList(likeKeys)).toArray();
        }
        HashMap<String, Long> ret = new HashMap<String, Long>(32);
        for (Object[] segLikeKeys : ArrayUtil.split(likeKeys, this.batchSize)) {
            StringBuilder sql = new StringBuilder(KSQL.dialect(NoShardingHint.genNoShardingSQL("select distinct fkey,findex from " + this.mapTable + " where ")));
            if (segLikeKeys.length == 1) {
                sql.append("fkey like ?");
            } else {
                int n = segLikeKeys.length;
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        sql.append(" or ");
                    }
                    sql.append("fkey like ?");
                }
            }
            try {
                XDBManageContext xm = XDB.get().withManageContext();
                Throwable throwable = null;
                try {
                    ResultSet rs = XDB.get().query(sql.toString(), segLikeKeys);
                    Throwable throwable2 = null;
                    try {
                        while (rs.next()) {
                            String key = rs.getString(1);
                            Long index = rs.getLong(2);
                            ret.put(key, index);
                            this.indexMap.put(key, index);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (xm == null) continue;
                    if (throwable != null) {
                        try {
                            xm.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    xm.close();
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(e);
            }
        }
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().stat(new QueryLikeIndexMapSpan(this.mapTable, likeKeys, ret));
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    public Map<String, Long> queryAllShardingMapTables(boolean useCache) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private long _queryMaxShardingIndex(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Long _queryShardingIndex(String key) {
        MetricsCollector mc;
        ShardingContext sc = ShardingContext.get();
        if (!sc.isMapTableLoaded()) {
            return this.queryAllShardingMapTables(false).get(key);
        }
        Long ret = this.indexMap.get(key);
        if (ret == null) {
            return this.queryAllShardingMapTables(false).get(key);
        }
        if (ret != null && (mc = MetricsCollector.getCurrent()).isActionMetricEnabled()) {
            mc.actionMetric().stat(new HitIndexMapCacheSpan(this.mapTable, ret));
        }
        return ret;
    }

    private void _insertShardingIndex(String key, long shardingIndex) {
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().stat(new InsertIndexMapSpan(this.mapTable, key, shardingIndex));
        }
        try (XDBExternal xdbe = XDBExternal.requiresNew("xdb._insertShardingIndex");){
            xdbe.execute(this.insertShardingIndexSQL, new Object[]{key, shardingIndex});
            this.indexMap.put(key, shardingIndex);
        }
    }

    public Map<String, Long> getGlobalIndexMap() {
        return this.globalIndexMap;
    }
}

