/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.map.mapper;

import java.util.Map;
import kd.bos.xdb.sharding.config.FieldType;
import kd.bos.xdb.sharding.strategy.map.mapper.AbstractValueMapper;

public class DivisionValueMapper
extends AbstractValueMapper {
    private final int division;

    public DivisionValueMapper(Map<String, String> paramMap) {
        super(paramMap);
        this.division = Integer.parseInt(paramMap.getOrDefault("division", "1"));
        if (this.division <= 0) {
            throw new IllegalArgumentException("DivisionValueMapper division should be 1 or more.");
        }
    }

    @Override
    public Object mapValue(int fieldIndex, String field, FieldType fieldType, Object value) {
        if (value == null) {
            return 0;
        }
        long divisor = 0L;
        divisor = value instanceof Number ? ((Number)value).longValue() : Long.parseLong((String)value);
        if (divisor <= 0L) {
            return 0;
        }
        return divisor / (long)this.division;
    }
}

