/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager;

import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.engine.ShardingEngineFactory;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.id.IDUtil;
import kd.bos.xdb.tablemanager.AliasManager;
import kd.bos.xdb.tablemanager.LockCreateAliasCall;
import kd.bos.xdb.tablemanager.TableName;

public class AliasManagerImpl
implements AliasManager {
    protected static final AliasManagerImpl INSTANCE = new AliasManagerImpl();
    private static final int table_max_length = 22;
    private static final String table_alias_prefix = "XDB_";
    public static final String index_alias_prefix = "XDB_IDX_";
    private static final Map<String, String> oriAliCache = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> aliOriCache = new ConcurrentHashMap<String, String>();

    @Override
    public String getTableAliasName(String originalName) {
        if (originalName.length() <= 22) {
            return originalName;
        }
        String key = AliasManagerImpl.getContextKey() + '#' + originalName;
        return oriAliCache.computeIfAbsent(key, k -> this.getOrCreateTableAliasName(originalName));
    }

    private String getOrCreateTableAliasName(String originalName) {
        String aliasName = this.loadAliasName(originalName, '0');
        if (aliasName != null) {
            return aliasName;
        }
        return LockCreateAliasCall.lockAndCall(originalName, () -> {
            String ialiasName = this.loadAliasName(originalName, '0');
            if (ialiasName == null) {
                ialiasName = this.insertAliasName(originalName, originalName, '0');
            }
            return ialiasName;
        });
    }

    private String loadAliasName(String originalName, char type) {
        String sql = "select falias_name from t_cbs_shard_name_map where ftype = ? and foriginal_name  = ? ";
        sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
        AtomicReference aliasName = new AtomicReference();
        try (XDBExternal xdbe = XDBExternal.requiresNew("xdb.getAliasName");){
            xdbe.query("sys", sql, new Object[]{Character.valueOf(type), originalName.toLowerCase()}, rs -> {
                try {
                    if (rs.next()) {
                        aliasName.set(rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(BosRes.get((String)"bos-xdb", (String)"AliasManagerImpl_0", (String)"\u83b7\u53d6\u522b\u540d\u5931\u8d25:", (Object[])new Object[0]) + originalName + "," + e.getMessage(), e);
                }
            });
        }
        return (String)aliasName.get();
    }

    private String insertAliasName(String table_name, String originalName, char type) {
        String sql = "insert into t_cbs_shard_name_map (fid,ftable_name,foriginal_name,falias_name,ftype,fcreatetime) values (?,?,?,?,?,?) ";
        sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
        String aliasName = ('1' == type ? index_alias_prefix : table_alias_prefix) + IDUtil.stringId();
        try (XDBExternal xdbe = XDBExternal.requiresNew("xdb.insertAliasName");){
            xdbe.execute("sys", sql, new Object[]{IDUtil.id(), table_name.toLowerCase(), originalName.toLowerCase(), aliasName.toLowerCase(), Character.valueOf(type), new Date()});
        }
        return aliasName;
    }

    @Override
    public String getTableOriginalName(String aliasName) {
        if (!aliasName.toUpperCase().startsWith(table_alias_prefix)) {
            return aliasName;
        }
        String key = AliasManagerImpl.getContextKey() + '#' + aliasName;
        return aliOriCache.computeIfAbsent(key, k -> this.loadOriginalName(aliasName, '0'));
    }

    private String loadOriginalName(String aliasName, char type) {
        String sql = "select foriginal_name from t_cbs_shard_name_map where ftype = ? and falias_name = ?";
        sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
        AtomicReference originalName = new AtomicReference();
        try (XDBExternal xdbe = XDBExternal.requiresNew("xdb.getAliasName");){
            xdbe.query("sys", sql, new Object[]{Character.valueOf(type), aliasName.toLowerCase()}, rs -> {
                try {
                    if (rs.next()) {
                        originalName.set(rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(BosRes.get((String)"bos-xdb", (String)"AliasManagerImpl_1", (String)"\u83b7\u53d6\u539f\u8868\u540d\u5931\u8d25:", (Object[])new Object[0]) + aliasName + "," + e.getMessage(), e);
                }
            });
        }
        return (String)originalName.get();
    }

    @Override
    public String getIndexAliasName(String tableName, String oriIndexName) {
        DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        if (dbType.getId().equals(DBType.mysql.getId())) {
            return oriIndexName;
        }
        TableName tn = TableName.of(tableName);
        if (oriIndexName.indexOf("$") > 0) {
            oriIndexName = oriIndexName.substring(0, oriIndexName.indexOf("$"));
        }
        if (tn.isPrototypeTable() || tn.isOriginalSnapTable()) {
            return oriIndexName + '$' + tn.getSuffix();
        }
        if (tn.isOriginalTable()) {
            return oriIndexName;
        }
        if (oriIndexName.length() > 22) {
            String originalName = tn.getOriginalName();
            String aliIndexName = this.getOrCreateIndexAliasName(originalName, oriIndexName);
            return aliIndexName + '$' + tn.getSuffix();
        }
        return oriIndexName + '$' + tn.getSuffix();
    }

    private String getOrCreateIndexAliasName(String originalName, String oriIndexName) {
        String aliasName = this.loadAliasName(oriIndexName, '1');
        if (aliasName != null) {
            return aliasName;
        }
        return LockCreateAliasCall.lockAndCall(oriIndexName, () -> {
            String ialiasName = this.loadAliasName(oriIndexName, '1');
            if (ialiasName == null) {
                ialiasName = this.insertAliasName(originalName, oriIndexName, '1');
            }
            return ialiasName;
        });
    }

    private static String getContextKey() {
        return ShardingEngineFactory.get().getShardingConfigProvider().getContextKey();
    }
}

