/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableManagerFactory;
import kd.bos.xdb.tablemanager.VersionedTableManager;
import kd.bos.xdb.tablemanager.ksql.KSQLTableManager;
import kd.bos.xdb.tablemanager.mysql.MySQLTableManager;

public class DefaultTableManagerFactory
implements TableManagerFactory {
    private Map<DBType, TableManager> tmMap = new ConcurrentHashMap<DBType, TableManager>();

    @Override
    public TableManager getTableManager() {
        return this.tmMap.computeIfAbsent(ConnectionProvider.get().getConnectionHolder().getDBType(), type -> {
            switch (type) {
                case mysql: 
                case tdsql: 
                case tidb: {
                    return new VersionedTableManager(new MySQLTableManager());
                }
            }
            if (XDBConfig.get().isUseKSQL()) {
                return new VersionedTableManager(new KSQLTableManager());
            }
            throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"DefaultTableManagerFactory_0", (String)"\u4e0d\u652f\u6301\u6570\u636e\u5e93\u7c7b\u578b:{0} ", (Object[])new Object[]{type}));
        });
    }
}

